/*
 * Decompiled with CFR 0.152.
 */
package megamu.shapetween;

import megamu.shapetween.Shaper;

public class CircularShaper
extends Shaper {
    public float pointX = 1.0f;
    public float pointY = 0.0f;
    public float m_Centerx;
    public float m_Centery;
    public float m_dRadius;

    public CircularShaper(int shapeMode, float transitionX, float transitionY) {
        this();
        this.setMode(shapeMode);
        this.setTransitionPoint(transitionX, transitionY);
    }

    public CircularShaper(int shapeMode, float transition) {
        this(shapeMode, transition, transition);
    }

    public CircularShaper(int shapeMode) {
        this();
        this.setMode(shapeMode);
    }

    public CircularShaper() {
        this.setMode(0);
    }

    public void throughPoint(float x, float y) {
        this.pointX = x;
        this.pointY = y;
    }

    protected float f(float x) {
        if (x == 1.0f || x == 0.0f) {
            return x;
        }
        if (this.pointX == 1.0f || this.pointY == 0.0f) {
            return 1.0f - this.sqrt(1.0f - x * x);
        }
        if (this.pointX == 0.0f || this.pointY == 1.0f) {
            return this.sqrt(1.0f - this.sq(1.0f - x));
        }
        float pt1x = 0.0f;
        float pt1y = 0.0f;
        float pt2x = this.pointX;
        float pt2y = this.pointY;
        float pt3x = 1.0f;
        float pt3y = 1.0f;
        if (!this.isPerpendicular(pt1x, pt1y, pt2x, pt2y, pt3x, pt3y)) {
            this.calcCircleFrom3Points(pt1x, pt1y, pt2x, pt2y, pt3x, pt3y);
        } else if (!this.isPerpendicular(pt1x, pt1y, pt3x, pt3y, pt2x, pt2y)) {
            this.calcCircleFrom3Points(pt1x, pt1y, pt3x, pt3y, pt2x, pt2y);
        } else if (!this.isPerpendicular(pt2x, pt2y, pt1x, pt1y, pt3x, pt3y)) {
            this.calcCircleFrom3Points(pt2x, pt2y, pt1x, pt1y, pt3x, pt3y);
        } else if (!this.isPerpendicular(pt2x, pt2y, pt3x, pt3y, pt1x, pt1y)) {
            this.calcCircleFrom3Points(pt2x, pt2y, pt3x, pt3y, pt1x, pt1y);
        } else if (!this.isPerpendicular(pt3x, pt3y, pt2x, pt2y, pt1x, pt1y)) {
            this.calcCircleFrom3Points(pt3x, pt3y, pt2x, pt2y, pt1x, pt1y);
        } else if (!this.isPerpendicular(pt3x, pt3y, pt1x, pt1y, pt2x, pt2y)) {
            this.calcCircleFrom3Points(pt3x, pt3y, pt1x, pt1y, pt2x, pt2y);
        } else {
            return 0.0f;
        }
        if (this.m_Centerx > 0.0f && this.m_Centerx < 1.0f) {
            if (this.pointX < this.m_Centerx) {
                this.m_Centerx = 1.0f;
                this.m_Centery = 0.0f;
                this.m_dRadius = 1.0f;
            } else {
                this.m_Centerx = 0.0f;
                this.m_Centery = 1.0f;
                this.m_dRadius = 1.0f;
            }
        }
        float y = 0.0f;
        y = x >= this.m_Centerx ? this.m_Centery - this.sqrt(this.sq(this.m_dRadius) - this.sq(x - this.m_Centerx)) : this.m_Centery + this.sqrt(this.sq(this.m_dRadius) - this.sq(x - this.m_Centerx));
        return y;
    }

    protected float df(float x) {
        float cx = this.m_Centerx;
        float cy = this.m_Centery;
        float r = this.m_dRadius;
        if (this.pointX == 1.0f || this.pointY == 0.0f) {
            cx = 0.0f;
            cy = 1.0f;
            r = 1.0f;
        }
        if (this.pointX == 0.0f || this.pointY == 1.0f) {
            cx = 1.0f;
            cy = 0.0f;
            r = 1.0f;
        }
        if (x == cx) {
            return 0.0f;
        }
        float y = this.f(x);
        if (Math.abs(x - cx) >= r) {
            return cy > y ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        return (cx - x) / (y - cy);
    }

    protected float ddf(float x) {
        float cx = this.m_Centerx;
        float cy = this.m_Centery;
        if (this.pointX == 1.0f || this.pointY == 0.0f) {
            cx = 0.0f;
            cy = 1.0f;
        }
        if (this.pointX == 0.0f || this.pointY == 1.0f) {
            cx = 1.0f;
            cy = 0.0f;
        }
        float y = this.f(x);
        double o = y - cy;
        double h = Math.sqrt(o * o + (double)((x - cx) * (x - cx)));
        double sin = o / h;
        return (float)(-1.0 / (sin * sin * sin));
    }

    protected boolean isPerpendicular(float pt1x, float pt1y, float pt2x, float pt2y, float pt3x, float pt3y) {
        float yDelta_a = pt2y - pt1y;
        float xDelta_a = pt2x - pt1x;
        float yDelta_b = pt3y - pt2y;
        float xDelta_b = pt3x - pt2x;
        float epsilon = 1.0E-6f;
        if (this.abs(xDelta_a) <= epsilon && this.abs(yDelta_b) <= epsilon) {
            return false;
        }
        if (this.abs(yDelta_a) <= epsilon) {
            return true;
        }
        if (this.abs(yDelta_b) <= epsilon) {
            return true;
        }
        if (this.abs(xDelta_a) <= epsilon) {
            return true;
        }
        return this.abs(xDelta_b) <= epsilon;
    }

    protected void calcCircleFrom3Points(float pt1x, float pt1y, float pt2x, float pt2y, float pt3x, float pt3y) {
        float yDelta_a = pt2y - pt1y;
        float xDelta_a = pt2x - pt1x;
        float yDelta_b = pt3y - pt2y;
        float xDelta_b = pt3x - pt2x;
        float epsilon = 1.0E-6f;
        if (this.abs(xDelta_a) <= epsilon && this.abs(yDelta_b) <= epsilon) {
            this.m_Centerx = 0.5f * (pt2x + pt3x);
            this.m_Centery = 0.5f * (pt1y + pt2y);
            this.m_dRadius = this.sqrt(this.sq(this.m_Centerx - pt1x) + this.sq(this.m_Centery - pt1y));
            return;
        }
        float aSlope = yDelta_a / xDelta_a;
        float bSlope = yDelta_b / xDelta_b;
        if (this.abs(aSlope - bSlope) <= epsilon) {
            return;
        }
        this.m_Centerx = (aSlope * bSlope * (pt1y - pt3y) + bSlope * (pt1x + pt2x) - aSlope * (pt2x + pt3x)) / (2.0f * (bSlope - aSlope));
        this.m_Centery = -1.0f * (this.m_Centerx - (pt1x + pt2x) / 2.0f) / aSlope + (pt1y + pt2y) / 2.0f;
        this.m_dRadius = this.sqrt(this.sq(this.m_Centerx - pt1x) + this.sq(this.m_Centery - pt1y));
    }

    protected float sq(float x) {
        return x * x;
    }

    protected float sqrt(float x) {
        return (float)Math.sqrt(x);
    }

    protected float abs(float x) {
        return Math.abs(x);
    }
}

