/*
 * Decompiled with CFR 0.152.
 */
package megamu.shapetween;

import megamu.shapetween.Shaper;

public class BezierShaper
extends Shaper {
    public static final double EPSILON = 1.0E-4;
    public float inHandleX = 0.4f;
    public float inHandleY = 0.05f;
    public float outHandleX = 0.6f;
    public float outHandleY = 0.95f;
    public double A;
    public double B;
    public double C;
    public double D;
    public double E;
    public double F;
    public double G;
    public double H;

    public BezierShaper(int shapeMode, float transitionX, float transitionY) {
        this();
        this.setMode(shapeMode);
        this.setTransitionPoint(transitionX, transitionY);
    }

    public BezierShaper(int shapeMode, float transition) {
        this(shapeMode, transition, transition);
    }

    public BezierShaper(int shapeMode) {
        this();
        this.setMode(shapeMode);
    }

    public BezierShaper() {
        this.calcConstants();
        this.setMode(0);
    }

    public void setInHandle(float x, float y) {
        this.inHandleX = Math.min(Math.max(0.0f, x), 1.0f);
        this.inHandleY = y;
        this.calcConstants();
    }

    public void setOutHandle(float x, float y) {
        this.outHandleX = Math.min(Math.max(0.0f, x), 1.0f);
        this.outHandleY = y;
        this.calcConstants();
    }

    protected void calcConstants() {
        this.A = 1.0 - 3.0 * (double)this.outHandleX + 3.0 * (double)this.inHandleX - 0.0;
        this.B = 3.0 * (double)this.outHandleX - 6.0 * (double)this.inHandleX + 0.0;
        this.C = 3.0 * (double)this.inHandleX - 0.0;
        this.D = 0.0;
        this.E = 1.0 - 3.0 * (double)this.outHandleY + 3.0 * (double)this.inHandleY - 0.0;
        this.F = 3.0 * (double)this.outHandleY - 6.0 * (double)this.inHandleY + 0.0;
        this.G = 3.0 * (double)this.inHandleY - 0.0;
        this.H = 0.0;
    }

    protected float f(float x) {
        double t = this.tFromX(x);
        return (float)this.yFromT(t, this.E, this.F, this.G, this.H);
    }

    protected float df(float x) {
        double t = this.tFromX(x);
        return (float)(this.dydt(t, this.E, this.F, this.G) / this.dxdt(t, this.A, this.B, this.C));
    }

    protected float ddf(float x) {
        double t = this.tFromX(x);
        double dxdt = this.dxdt(t, this.A, this.B, this.C);
        return (float)((this.dydtdt(t, this.E, this.F) * dxdt - this.dydt(t, this.E, this.F, this.G) * this.dxdtdt(t, this.A, this.B)) / dxdt);
    }

    protected double tFromX(float x) {
        double currentt = x;
        int nRefinementIterations = 5;
        int i = 0;
        while (i < nRefinementIterations) {
            double currentx = this.xFromT(currentt, this.A, this.B, this.C, this.D);
            double currentslope = this.slopeFromT(currentt, this.A, this.B, this.C);
            double dt = (currentx - (double)x) * currentslope;
            currentt -= dt;
            if (Math.abs(dt) < 1.0E-4) break;
            ++i;
        }
        return currentt;
    }

    protected double slopeFromT(double t, double A, double B, double C) {
        return 1.0 / (3.0 * A * t * t + 2.0 * B * t + C);
    }

    protected double xFromT(double t, double A, double B, double C, double D) {
        return A * (t * t * t) + B * (t * t) + C * t + D;
    }

    protected double yFromT(double t, double E, double F, double G, double H) {
        return E * (t * t * t) + F * (t * t) + G * t + H;
    }

    protected double dxdt(double t, double A, double B, double C) {
        return 3.0 * A * (t * t) + 2.0 * B * t + C;
    }

    protected double dydt(double t, double E, double F, double G) {
        return 3.0 * E * (t * t) + 2.0 * F * t + G;
    }

    protected double dxdtdt(double t, double A, double B) {
        return 6.0 * A * t + 2.0 * B;
    }

    protected double dydtdt(double t, double E, double F) {
        return 6.0 * E * t + 2.0 * F;
    }
}

