/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import processing.core.PConstants;
import processing.core.PGraphics3D;
import processing.core.PImage;
import processing.core.PMatrix;

public class PTriangle
implements PConstants {
    static final int R_GOURAUD = 1;
    static final int R_TEXTURE8 = 2;
    static final int R_TEXTURE24 = 4;
    static final int R_TEXTURE32 = 8;
    static final int R_ALPHA = 16;
    private int[] m_pixels;
    private int[] m_texture;
    private int[] m_stencil;
    private float[] m_zbuffer;
    private int SCREEN_WIDTH;
    private int SCREEN_HEIGHT;
    private int TEX_WIDTH;
    private int TEX_HEIGHT;
    private float F_TEX_WIDTH;
    private float F_TEX_HEIGHT;
    public boolean INTERPOLATE_UV;
    public boolean INTERPOLATE_RGB;
    public boolean INTERPOLATE_ALPHA;
    private static final int DEFAULT_INTERP_POWER = 3;
    private static int TEX_INTERP_POWER = 3;
    private float[] x_array = new float[3];
    private float[] y_array = new float[3];
    private float[] z_array = new float[3];
    private float[] camX;
    private float[] camY;
    private float[] camZ;
    private float[] u_array = new float[3];
    private float[] v_array = new float[3];
    private float[] r_array = new float[3];
    private float[] g_array = new float[3];
    private float[] b_array = new float[3];
    private float[] a_array = new float[3];
    private int o0;
    private int o1;
    private int o2;
    private float r0;
    private float r1;
    private float r2;
    private float g0;
    private float g1;
    private float g2;
    private float b0;
    private float b1;
    private float b2;
    private float a0;
    private float a1;
    private float a2;
    private float u0;
    private float u1;
    private float u2;
    private float v0;
    private float v1;
    private float v2;
    private float dx2;
    private float dy0;
    private float dy1;
    private float dy2;
    private float dz0;
    private float dz2;
    private float du0;
    private float du2;
    private float dv0;
    private float dv2;
    private float dr0;
    private float dr2;
    private float dg0;
    private float dg2;
    private float db0;
    private float db2;
    private float da0;
    private float da2;
    private float uleft;
    private float vleft;
    private float uleftadd;
    private float vleftadd;
    private float xleft;
    private float xrght;
    private float xadd1;
    private float xadd2;
    private float zleft;
    private float zleftadd;
    private float rleft;
    private float gleft;
    private float bleft;
    private float aleft;
    private float rleftadd;
    private float gleftadd;
    private float bleftadd;
    private float aleftadd;
    private float dta;
    private float temp;
    private float width;
    private int iuadd;
    private int ivadd;
    private int iradd;
    private int igadd;
    private int ibadd;
    private int iaadd;
    private float izadd;
    private int m_fill;
    public int m_drawFlags;
    private int m_index;
    private PGraphics3D parent;
    private boolean noDepthTest;
    private boolean m_culling;
    private boolean m_singleRight;
    private boolean m_bilinear = true;
    private float ax;
    private float ay;
    private float az;
    private float bx;
    private float by;
    private float bz;
    private float cx;
    private float cy;
    private float cz;
    private float nearPlaneWidth;
    private float nearPlaneHeight;
    private float nearPlaneDepth;
    private float xmult;
    private float ymult;
    private float newax;
    private float newbx;
    private float newcx;
    private boolean firstSegment;

    public PTriangle(PGraphics3D pGraphics3D) {
        this.camX = new float[3];
        this.camY = new float[3];
        this.camZ = new float[3];
        this.parent = pGraphics3D;
        this.reset();
    }

    public void reset() {
        this.SCREEN_WIDTH = this.parent.width;
        this.SCREEN_HEIGHT = this.parent.height;
        this.m_pixels = this.parent.pixels;
        this.m_stencil = this.parent.stencil;
        this.m_zbuffer = this.parent.zbuffer;
        this.noDepthTest = this.parent.hints[5];
        this.INTERPOLATE_UV = false;
        this.INTERPOLATE_RGB = false;
        this.INTERPOLATE_ALPHA = false;
        this.m_texture = null;
        this.m_drawFlags = 0;
    }

    public void setCulling(boolean bl) {
        this.m_culling = bl;
    }

    public void setVertices(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.x_array[0] = f;
        this.x_array[1] = f4;
        this.x_array[2] = f7;
        this.y_array[0] = f2;
        this.y_array[1] = f5;
        this.y_array[2] = f8;
        this.z_array[0] = f3;
        this.z_array[1] = f6;
        this.z_array[2] = f9;
    }

    public void setCamVertices(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.camX[0] = f;
        this.camX[1] = f4;
        this.camX[2] = f7;
        this.camY[0] = f2;
        this.camY[1] = f5;
        this.camY[2] = f8;
        this.camZ[0] = f3;
        this.camZ[1] = f6;
        this.camZ[2] = f9;
    }

    public void setUV(float f, float f2, float f3, float f4, float f5, float f6) {
        this.u_array[0] = (f * this.F_TEX_WIDTH + 0.5f) * 65536.0f;
        this.u_array[1] = (f3 * this.F_TEX_WIDTH + 0.5f) * 65536.0f;
        this.u_array[2] = (f5 * this.F_TEX_WIDTH + 0.5f) * 65536.0f;
        this.v_array[0] = (f2 * this.F_TEX_HEIGHT + 0.5f) * 65536.0f;
        this.v_array[1] = (f4 * this.F_TEX_HEIGHT + 0.5f) * 65536.0f;
        this.v_array[2] = (f6 * this.F_TEX_HEIGHT + 0.5f) * 65536.0f;
    }

    public void setIntensities(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        if (f4 != 1.0f || f8 != 1.0f || f12 != 1.0f) {
            this.INTERPOLATE_ALPHA = true;
            this.a_array[0] = (f4 * 253.0f + 1.0f) * 65536.0f;
            this.a_array[1] = (f8 * 253.0f + 1.0f) * 65536.0f;
            this.a_array[2] = (f12 * 253.0f + 1.0f) * 65536.0f;
            this.m_drawFlags |= 0x10;
        } else {
            this.INTERPOLATE_ALPHA = false;
            this.m_drawFlags &= 0xFFFFFFEF;
        }
        if (f != f5 || f5 != f9) {
            this.INTERPOLATE_RGB = true;
            this.m_drawFlags |= 1;
        } else if (f2 != f6 || f6 != f10) {
            this.INTERPOLATE_RGB = true;
            this.m_drawFlags |= 1;
        } else if (f3 != f7 || f7 != f11) {
            this.INTERPOLATE_RGB = true;
            this.m_drawFlags |= 1;
        } else {
            this.m_drawFlags &= 0xFFFFFFFE;
        }
        this.r_array[0] = (f * 253.0f + 1.0f) * 65536.0f;
        this.r_array[1] = (f5 * 253.0f + 1.0f) * 65536.0f;
        this.r_array[2] = (f9 * 253.0f + 1.0f) * 65536.0f;
        this.g_array[0] = (f2 * 253.0f + 1.0f) * 65536.0f;
        this.g_array[1] = (f6 * 253.0f + 1.0f) * 65536.0f;
        this.g_array[2] = (f10 * 253.0f + 1.0f) * 65536.0f;
        this.b_array[0] = (f3 * 253.0f + 1.0f) * 65536.0f;
        this.b_array[1] = (f7 * 253.0f + 1.0f) * 65536.0f;
        this.b_array[2] = (f11 * 253.0f + 1.0f) * 65536.0f;
        this.m_fill = 0xFF000000 | (int)(255.0f * f) << 16 | (int)(255.0f * f2) << 8 | (int)(255.0f * f3);
    }

    public void setTexture(PImage pImage) {
        this.m_texture = pImage.pixels;
        this.TEX_WIDTH = pImage.width;
        this.TEX_HEIGHT = pImage.height;
        this.F_TEX_WIDTH = this.TEX_WIDTH - 1;
        this.F_TEX_HEIGHT = this.TEX_HEIGHT - 1;
        this.INTERPOLATE_UV = true;
        if (pImage.format == 2) {
            this.m_drawFlags |= 8;
        } else if (pImage.format == 1) {
            this.m_drawFlags |= 4;
        } else if (pImage.format == 4) {
            this.m_drawFlags |= 2;
        }
    }

    public void setUV(float[] fArray, float[] fArray2) {
        if (this.m_bilinear) {
            this.u_array[0] = fArray[0] * this.F_TEX_WIDTH * 65500.0f;
            this.u_array[1] = fArray[1] * this.F_TEX_WIDTH * 65500.0f;
            this.u_array[2] = fArray[2] * this.F_TEX_WIDTH * 65500.0f;
            this.v_array[0] = fArray2[0] * this.F_TEX_HEIGHT * 65500.0f;
            this.v_array[1] = fArray2[1] * this.F_TEX_HEIGHT * 65500.0f;
            this.v_array[2] = fArray2[2] * this.F_TEX_HEIGHT * 65500.0f;
        } else {
            this.u_array[0] = fArray[0] * (float)this.TEX_WIDTH * 65500.0f;
            this.u_array[1] = fArray[1] * (float)this.TEX_WIDTH * 65500.0f;
            this.u_array[2] = fArray[2] * (float)this.TEX_WIDTH * 65500.0f;
            this.v_array[0] = fArray2[0] * (float)this.TEX_HEIGHT * 65500.0f;
            this.v_array[1] = fArray2[1] * (float)this.TEX_HEIGHT * 65500.0f;
            this.v_array[2] = fArray2[2] * (float)this.TEX_HEIGHT * 65500.0f;
        }
    }

    public void setIndex(int n) {
        this.m_index = n;
    }

    public void render() {
        int n;
        float f;
        float f2 = this.y_array[0];
        float f3 = this.y_array[1];
        float f4 = this.y_array[2];
        this.firstSegment = true;
        if (this.m_culling && (this.x_array[2] - (f = this.x_array[0])) * (f3 - f2) < (this.x_array[1] - f) * (f4 - f2)) {
            return;
        }
        if (f2 < f3) {
            if (f4 < f3) {
                if (f4 < f2) {
                    this.o0 = 2;
                    this.o1 = 0;
                    this.o2 = 1;
                } else {
                    this.o0 = 0;
                    this.o1 = 2;
                    this.o2 = 1;
                }
            } else {
                this.o0 = 0;
                this.o1 = 1;
                this.o2 = 2;
            }
        } else if (f4 > f3) {
            if (f4 < f2) {
                this.o0 = 1;
                this.o1 = 2;
                this.o2 = 0;
            } else {
                this.o0 = 1;
                this.o1 = 0;
                this.o2 = 2;
            }
        } else {
            this.o0 = 2;
            this.o1 = 1;
            this.o2 = 0;
        }
        f2 = this.y_array[this.o0];
        int n2 = (int)(f2 + 0.5f);
        if (n2 > this.SCREEN_HEIGHT) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = (int)((f4 = this.y_array[this.o2]) + 0.5f)) < 0) {
            return;
        }
        if (n > this.SCREEN_HEIGHT) {
            n = this.SCREEN_HEIGHT;
        }
        if (n > n2) {
            f = this.x_array[this.o0];
            float f5 = this.x_array[this.o1];
            float f6 = this.x_array[this.o2];
            f3 = this.y_array[this.o1];
            int n3 = (int)(f3 + 0.5f);
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > this.SCREEN_HEIGHT) {
                n3 = this.SCREEN_HEIGHT;
            }
            this.dx2 = f6 - f;
            this.dy0 = f3 - f2;
            this.dy2 = f4 - f2;
            this.xadd2 = this.dx2 / this.dy2;
            this.temp = this.dy0 / this.dy2;
            this.width = this.temp * this.dx2 + f - f5;
            if (this.INTERPOLATE_ALPHA) {
                this.a0 = this.a_array[this.o0];
                this.a1 = this.a_array[this.o1];
                this.a2 = this.a_array[this.o2];
                this.da0 = this.a1 - this.a0;
                this.da2 = this.a2 - this.a0;
                this.iaadd = (int)((this.temp * this.da2 - this.da0) / this.width);
            }
            if (this.INTERPOLATE_RGB) {
                this.r0 = this.r_array[this.o0];
                this.r1 = this.r_array[this.o1];
                this.r2 = this.r_array[this.o2];
                this.g0 = this.g_array[this.o0];
                this.g1 = this.g_array[this.o1];
                this.g2 = this.g_array[this.o2];
                this.b0 = this.b_array[this.o0];
                this.b1 = this.b_array[this.o1];
                this.b2 = this.b_array[this.o2];
                this.dr0 = this.r1 - this.r0;
                this.dg0 = this.g1 - this.g0;
                this.db0 = this.b1 - this.b0;
                this.dr2 = this.r2 - this.r0;
                this.dg2 = this.g2 - this.g0;
                this.db2 = this.b2 - this.b0;
                this.iradd = (int)((this.temp * this.dr2 - this.dr0) / this.width);
                this.igadd = (int)((this.temp * this.dg2 - this.dg0) / this.width);
                this.ibadd = (int)((this.temp * this.db2 - this.db0) / this.width);
            }
            if (this.INTERPOLATE_UV) {
                this.u0 = this.u_array[this.o0];
                this.u1 = this.u_array[this.o1];
                this.u2 = this.u_array[this.o2];
                this.v0 = this.v_array[this.o0];
                this.v1 = this.v_array[this.o1];
                this.v2 = this.v_array[this.o2];
                this.du0 = this.u1 - this.u0;
                this.dv0 = this.v1 - this.v0;
                this.du2 = this.u2 - this.u0;
                this.dv2 = this.v2 - this.v0;
                this.iuadd = (int)((this.temp * this.du2 - this.du0) / this.width);
                this.ivadd = (int)((this.temp * this.dv2 - this.dv0) / this.width);
            }
            float f7 = this.z_array[this.o0];
            float f8 = this.z_array[this.o1];
            float f9 = this.z_array[this.o2];
            this.dz0 = f8 - f7;
            this.dz2 = f9 - f7;
            this.izadd = (this.temp * this.dz2 - this.dz0) / this.width;
            if (n3 > n2) {
                this.dta = (float)n2 + 0.5f - f2;
                this.xadd1 = (f5 - f) / this.dy0;
                if (this.xadd2 > this.xadd1) {
                    this.xleft = f + this.dta * this.xadd1;
                    this.xrght = f + this.dta * this.xadd2;
                    this.zleftadd = this.dz0 / this.dy0;
                    this.zleft = this.dta * this.zleftadd + f7;
                    if (this.INTERPOLATE_UV) {
                        this.uleftadd = this.du0 / this.dy0;
                        this.vleftadd = this.dv0 / this.dy0;
                        this.uleft = this.dta * this.uleftadd + this.u0;
                        this.vleft = this.dta * this.vleftadd + this.v0;
                    }
                    if (this.INTERPOLATE_RGB) {
                        this.rleftadd = this.dr0 / this.dy0;
                        this.gleftadd = this.dg0 / this.dy0;
                        this.bleftadd = this.db0 / this.dy0;
                        this.rleft = this.dta * this.rleftadd + this.r0;
                        this.gleft = this.dta * this.gleftadd + this.g0;
                        this.bleft = this.dta * this.bleftadd + this.b0;
                    }
                    if (this.INTERPOLATE_ALPHA) {
                        this.aleftadd = this.da0 / this.dy0;
                        this.aleft = this.dta * this.aleftadd + this.a0;
                        if (this.m_drawFlags == 16) {
                            this.drawsegment_plain_alpha(this.xadd1, this.xadd2, n2, n3);
                        } else if (this.m_drawFlags == 17) {
                            this.drawsegment_gouraud_alpha(this.xadd1, this.xadd2, n2, n3);
                        } else if (this.m_drawFlags == 18) {
                            this.drawsegment_texture8_alpha(this.xadd1, this.xadd2, n2, n3);
                        } else if (this.m_drawFlags == 20) {
                            this.drawsegment_texture24_alpha(this.xadd1, this.xadd2, n2, n3);
                        } else if (this.m_drawFlags == 24) {
                            this.drawsegment_texture32_alpha(this.xadd1, this.xadd2, n2, n3);
                        } else if (this.m_drawFlags == 19) {
                            this.drawsegment_gouraud_texture8_alpha(this.xadd1, this.xadd2, n2, n3);
                        } else if (this.m_drawFlags == 21) {
                            this.drawsegment_gouraud_texture24_alpha(this.xadd1, this.xadd2, n2, n3);
                        } else if (this.m_drawFlags == 25) {
                            this.drawsegment_gouraud_texture32_alpha(this.xadd1, this.xadd2, n2, n3);
                        }
                    } else if (this.m_drawFlags == 0) {
                        this.drawsegment_plain(this.xadd1, this.xadd2, n2, n3);
                    } else if (this.m_drawFlags == 1) {
                        this.drawsegment_gouraud(this.xadd1, this.xadd2, n2, n3);
                    } else if (this.m_drawFlags == 2) {
                        this.drawsegment_texture8(this.xadd1, this.xadd2, n2, n3);
                    } else if (this.m_drawFlags == 4) {
                        this.drawsegment_texture24(this.xadd1, this.xadd2, n2, n3);
                    } else if (this.m_drawFlags == 8) {
                        this.drawsegment_texture32(this.xadd1, this.xadd2, n2, n3);
                    } else if (this.m_drawFlags == 3) {
                        this.drawsegment_gouraud_texture8(this.xadd1, this.xadd2, n2, n3);
                    } else if (this.m_drawFlags == 5) {
                        this.drawsegment_gouraud_texture24(this.xadd1, this.xadd2, n2, n3);
                    } else if (this.m_drawFlags == 9) {
                        this.drawsegment_gouraud_texture32(this.xadd1, this.xadd2, n2, n3);
                    }
                    this.m_singleRight = true;
                } else {
                    this.xleft = f + this.dta * this.xadd2;
                    this.xrght = f + this.dta * this.xadd1;
                    this.zleftadd = this.dz2 / this.dy2;
                    this.zleft = this.dta * this.zleftadd + f7;
                    if (this.INTERPOLATE_UV) {
                        this.uleftadd = this.du2 / this.dy2;
                        this.vleftadd = this.dv2 / this.dy2;
                        this.uleft = this.dta * this.uleftadd + this.u0;
                        this.vleft = this.dta * this.vleftadd + this.v0;
                    }
                    if (this.INTERPOLATE_RGB) {
                        this.rleftadd = this.dr2 / this.dy2;
                        this.gleftadd = this.dg2 / this.dy2;
                        this.bleftadd = this.db2 / this.dy2;
                        this.rleft = this.dta * this.rleftadd + this.r0;
                        this.gleft = this.dta * this.gleftadd + this.g0;
                        this.bleft = this.dta * this.bleftadd + this.b0;
                    }
                    if (this.INTERPOLATE_ALPHA) {
                        this.aleftadd = this.da2 / this.dy2;
                        this.aleft = this.dta * this.aleftadd + this.a0;
                        if (this.m_drawFlags == 16) {
                            this.drawsegment_plain_alpha(this.xadd2, this.xadd1, n2, n3);
                        } else if (this.m_drawFlags == 17) {
                            this.drawsegment_gouraud_alpha(this.xadd2, this.xadd1, n2, n3);
                        } else if (this.m_drawFlags == 18) {
                            this.drawsegment_texture8_alpha(this.xadd2, this.xadd1, n2, n3);
                        } else if (this.m_drawFlags == 20) {
                            this.drawsegment_texture24_alpha(this.xadd2, this.xadd1, n2, n3);
                        } else if (this.m_drawFlags == 24) {
                            this.drawsegment_texture32_alpha(this.xadd2, this.xadd1, n2, n3);
                        } else if (this.m_drawFlags == 19) {
                            this.drawsegment_gouraud_texture8_alpha(this.xadd2, this.xadd1, n2, n3);
                        } else if (this.m_drawFlags == 21) {
                            this.drawsegment_gouraud_texture24_alpha(this.xadd2, this.xadd1, n2, n3);
                        } else if (this.m_drawFlags == 25) {
                            this.drawsegment_gouraud_texture32_alpha(this.xadd2, this.xadd1, n2, n3);
                        }
                    } else if (this.m_drawFlags == 0) {
                        this.drawsegment_plain(this.xadd2, this.xadd1, n2, n3);
                    } else if (this.m_drawFlags == 1) {
                        this.drawsegment_gouraud(this.xadd2, this.xadd1, n2, n3);
                    } else if (this.m_drawFlags == 2) {
                        this.drawsegment_texture8(this.xadd2, this.xadd1, n2, n3);
                    } else if (this.m_drawFlags == 4) {
                        this.drawsegment_texture24(this.xadd2, this.xadd1, n2, n3);
                    } else if (this.m_drawFlags == 8) {
                        this.drawsegment_texture32(this.xadd2, this.xadd1, n2, n3);
                    } else if (this.m_drawFlags == 3) {
                        this.drawsegment_gouraud_texture8(this.xadd2, this.xadd1, n2, n3);
                    } else if (this.m_drawFlags == 5) {
                        this.drawsegment_gouraud_texture24(this.xadd2, this.xadd1, n2, n3);
                    } else if (this.m_drawFlags == 9) {
                        this.drawsegment_gouraud_texture32(this.xadd2, this.xadd1, n2, n3);
                    }
                    this.m_singleRight = false;
                }
                if (n == n3) {
                    return;
                }
                this.dy1 = f4 - f3;
                this.xadd1 = (f6 - f5) / this.dy1;
            } else {
                this.dy1 = f4 - f3;
                this.xadd1 = (f6 - f5) / this.dy1;
                if (this.xadd2 < this.xadd1) {
                    this.xrght = ((float)n3 + 0.5f - f2) * this.xadd2 + f;
                    this.m_singleRight = true;
                } else {
                    this.dta = (float)n3 + 0.5f - f2;
                    this.xleft = this.dta * this.xadd2 + f;
                    this.zleftadd = this.dz2 / this.dy2;
                    this.zleft = this.dta * this.zleftadd + f7;
                    if (this.INTERPOLATE_UV) {
                        this.uleftadd = this.du2 / this.dy2;
                        this.vleftadd = this.dv2 / this.dy2;
                        this.uleft = this.dta * this.uleftadd + this.u0;
                        this.vleft = this.dta * this.vleftadd + this.v0;
                    }
                    if (this.INTERPOLATE_RGB) {
                        this.rleftadd = this.dr2 / this.dy2;
                        this.gleftadd = this.dg2 / this.dy2;
                        this.bleftadd = this.db2 / this.dy2;
                        this.rleft = this.dta * this.rleftadd + this.r0;
                        this.gleft = this.dta * this.gleftadd + this.g0;
                        this.bleft = this.dta * this.bleftadd + this.b0;
                    }
                    if (this.INTERPOLATE_ALPHA) {
                        this.aleftadd = this.da2 / this.dy2;
                        this.aleft = this.dta * this.aleftadd + this.a0;
                    }
                    this.m_singleRight = false;
                }
            }
            if (this.m_singleRight) {
                this.dta = (float)n3 + 0.5f - f3;
                this.xleft = this.dta * this.xadd1 + f5;
                this.zleftadd = (f9 - f8) / this.dy1;
                this.zleft = this.dta * this.zleftadd + f8;
                if (this.INTERPOLATE_UV) {
                    this.uleftadd = (this.u2 - this.u1) / this.dy1;
                    this.vleftadd = (this.v2 - this.v1) / this.dy1;
                    this.uleft = this.dta * this.uleftadd + this.u1;
                    this.vleft = this.dta * this.vleftadd + this.v1;
                }
                if (this.INTERPOLATE_RGB) {
                    this.rleftadd = (this.r2 - this.r1) / this.dy1;
                    this.gleftadd = (this.g2 - this.g1) / this.dy1;
                    this.bleftadd = (this.b2 - this.b1) / this.dy1;
                    this.rleft = this.dta * this.rleftadd + this.r1;
                    this.gleft = this.dta * this.gleftadd + this.g1;
                    this.bleft = this.dta * this.bleftadd + this.b1;
                }
                if (this.INTERPOLATE_ALPHA) {
                    this.aleftadd = (this.a2 - this.a1) / this.dy1;
                    this.aleft = this.dta * this.aleftadd + this.a1;
                    if (this.m_drawFlags == 16) {
                        this.drawsegment_plain_alpha(this.xadd1, this.xadd2, n3, n);
                    } else if (this.m_drawFlags == 17) {
                        this.drawsegment_gouraud_alpha(this.xadd1, this.xadd2, n3, n);
                    } else if (this.m_drawFlags == 18) {
                        this.drawsegment_texture8_alpha(this.xadd1, this.xadd2, n3, n);
                    } else if (this.m_drawFlags == 20) {
                        this.drawsegment_texture24_alpha(this.xadd1, this.xadd2, n3, n);
                    } else if (this.m_drawFlags == 24) {
                        this.drawsegment_texture32_alpha(this.xadd1, this.xadd2, n3, n);
                    } else if (this.m_drawFlags == 19) {
                        this.drawsegment_gouraud_texture8_alpha(this.xadd1, this.xadd2, n3, n);
                    } else if (this.m_drawFlags == 21) {
                        this.drawsegment_gouraud_texture24_alpha(this.xadd1, this.xadd2, n3, n);
                    } else if (this.m_drawFlags == 25) {
                        this.drawsegment_gouraud_texture32_alpha(this.xadd1, this.xadd2, n3, n);
                    }
                } else if (this.m_drawFlags == 0) {
                    this.drawsegment_plain(this.xadd1, this.xadd2, n3, n);
                } else if (this.m_drawFlags == 1) {
                    this.drawsegment_gouraud(this.xadd1, this.xadd2, n3, n);
                } else if (this.m_drawFlags == 2) {
                    this.drawsegment_texture8(this.xadd1, this.xadd2, n3, n);
                } else if (this.m_drawFlags == 4) {
                    this.drawsegment_texture24(this.xadd1, this.xadd2, n3, n);
                } else if (this.m_drawFlags == 8) {
                    this.drawsegment_texture32(this.xadd1, this.xadd2, n3, n);
                } else if (this.m_drawFlags == 3) {
                    this.drawsegment_gouraud_texture8(this.xadd1, this.xadd2, n3, n);
                } else if (this.m_drawFlags == 5) {
                    this.drawsegment_gouraud_texture24(this.xadd1, this.xadd2, n3, n);
                } else if (this.m_drawFlags == 9) {
                    this.drawsegment_gouraud_texture32(this.xadd1, this.xadd2, n3, n);
                }
            } else {
                this.xrght = ((float)n3 + 0.5f - f3) * this.xadd1 + f5;
                if (this.INTERPOLATE_ALPHA) {
                    if (this.m_drawFlags == 16) {
                        this.drawsegment_plain_alpha(this.xadd2, this.xadd1, n3, n);
                    } else if (this.m_drawFlags == 17) {
                        this.drawsegment_gouraud_alpha(this.xadd2, this.xadd1, n3, n);
                    } else if (this.m_drawFlags == 18) {
                        this.drawsegment_texture8_alpha(this.xadd2, this.xadd1, n3, n);
                    } else if (this.m_drawFlags == 20) {
                        this.drawsegment_texture24_alpha(this.xadd2, this.xadd1, n3, n);
                    } else if (this.m_drawFlags == 24) {
                        this.drawsegment_texture32_alpha(this.xadd2, this.xadd1, n3, n);
                    } else if (this.m_drawFlags == 19) {
                        this.drawsegment_gouraud_texture8_alpha(this.xadd2, this.xadd1, n3, n);
                    } else if (this.m_drawFlags == 21) {
                        this.drawsegment_gouraud_texture24_alpha(this.xadd2, this.xadd1, n3, n);
                    } else if (this.m_drawFlags == 25) {
                        this.drawsegment_gouraud_texture32_alpha(this.xadd2, this.xadd1, n3, n);
                    }
                } else if (this.m_drawFlags == 0) {
                    this.drawsegment_plain(this.xadd2, this.xadd1, n3, n);
                } else if (this.m_drawFlags == 1) {
                    this.drawsegment_gouraud(this.xadd2, this.xadd1, n3, n);
                } else if (this.m_drawFlags == 2) {
                    this.drawsegment_texture8(this.xadd2, this.xadd1, n3, n);
                } else if (this.m_drawFlags == 4) {
                    this.drawsegment_texture24(this.xadd2, this.xadd1, n3, n);
                } else if (this.m_drawFlags == 8) {
                    this.drawsegment_texture32(this.xadd2, this.xadd1, n3, n);
                } else if (this.m_drawFlags == 3) {
                    this.drawsegment_gouraud_texture8(this.xadd2, this.xadd1, n3, n);
                } else if (this.m_drawFlags == 5) {
                    this.drawsegment_gouraud_texture24(this.xadd2, this.xadd1, n3, n);
                } else if (this.m_drawFlags == 9) {
                    this.drawsegment_gouraud_texture32(this.xadd2, this.xadd1, n3, n);
                }
            }
        }
    }

    private boolean precomputeAccurateTexturing() {
        float f = 65500.0f;
        float f2 = 65500.0f;
        if (this.firstSegment) {
            PMatrix pMatrix = new PMatrix(this.u_array[this.o0] / f, this.v_array[this.o0] / f2, 1.0f, 0.0f, this.u_array[this.o1] / f, this.v_array[this.o1] / f2, 1.0f, 0.0f, this.u_array[this.o2] / f, this.v_array[this.o2] / f2, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
            if ((pMatrix = pMatrix.invert()) == null) {
                return false;
            }
            float f3 = pMatrix.m00 * this.camX[this.o0] + pMatrix.m01 * this.camX[this.o1] + pMatrix.m02 * this.camX[this.o2];
            float f4 = pMatrix.m10 * this.camX[this.o0] + pMatrix.m11 * this.camX[this.o1] + pMatrix.m12 * this.camX[this.o2];
            float f5 = pMatrix.m20 * this.camX[this.o0] + pMatrix.m21 * this.camX[this.o1] + pMatrix.m22 * this.camX[this.o2];
            float f6 = pMatrix.m00 * this.camY[this.o0] + pMatrix.m01 * this.camY[this.o1] + pMatrix.m02 * this.camY[this.o2];
            float f7 = pMatrix.m10 * this.camY[this.o0] + pMatrix.m11 * this.camY[this.o1] + pMatrix.m12 * this.camY[this.o2];
            float f8 = pMatrix.m20 * this.camY[this.o0] + pMatrix.m21 * this.camY[this.o1] + pMatrix.m22 * this.camY[this.o2];
            float f9 = -(pMatrix.m00 * this.camZ[this.o0] + pMatrix.m01 * this.camZ[this.o1] + pMatrix.m02 * this.camZ[this.o2]);
            float f10 = -(pMatrix.m10 * this.camZ[this.o0] + pMatrix.m11 * this.camZ[this.o1] + pMatrix.m12 * this.camZ[this.o2]);
            float f11 = -(pMatrix.m20 * this.camZ[this.o0] + pMatrix.m21 * this.camZ[this.o1] + pMatrix.m22 * this.camZ[this.o2]);
            float f12 = f5;
            float f13 = f8;
            float f14 = f11;
            float f15 = f3 * (float)this.TEX_WIDTH + f5;
            float f16 = f6 * (float)this.TEX_WIDTH + f8;
            float f17 = f9 * (float)this.TEX_WIDTH + f11;
            float f18 = f4 * (float)this.TEX_HEIGHT + f5;
            float f19 = f7 * (float)this.TEX_HEIGHT + f8;
            float f20 = f10 * (float)this.TEX_HEIGHT + f11;
            float f21 = f15 - f5;
            float f22 = f16 - f8;
            float f23 = f17 - f11;
            float f24 = f18 - f5;
            float f25 = f19 - f8;
            float f26 = f20 - f11;
            this.ax = (f13 * f26 - f14 * f25) * (float)this.TEX_WIDTH;
            this.ay = (f14 * f24 - f12 * f26) * (float)this.TEX_WIDTH;
            this.az = (f12 * f25 - f13 * f24) * (float)this.TEX_WIDTH;
            this.bx = (f22 * f14 - f23 * f13) * (float)this.TEX_HEIGHT;
            this.by = (f23 * f12 - f21 * f14) * (float)this.TEX_HEIGHT;
            this.bz = (f21 * f13 - f22 * f12) * (float)this.TEX_HEIGHT;
            this.cx = f25 * f23 - f26 * f22;
            this.cy = f26 * f21 - f24 * f23;
            this.cz = f24 * f22 - f25 * f21;
        }
        this.nearPlaneWidth = this.parent.rightScreen - this.parent.leftScreen;
        this.nearPlaneHeight = this.parent.topScreen - this.parent.bottomScreen;
        this.nearPlaneDepth = this.parent.nearPlane;
        this.xmult = this.nearPlaneWidth / (float)this.SCREEN_WIDTH;
        this.ymult = this.nearPlaneHeight / (float)this.SCREEN_HEIGHT;
        this.newax = this.ax * this.xmult;
        this.newbx = this.bx * this.xmult;
        this.newcx = this.cx * this.xmult;
        return true;
    }

    public static void setInterpPower(int n) {
        TEX_INTERP_POWER = n;
    }

    private void drawsegment_plain(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_fill;
        int n4 = this.m_index;
        while (n < n2) {
            int n5;
            int n6 = (int)(this.xleft + 0.5f);
            if (n6 < 0) {
                n6 = 0;
            }
            if ((n5 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n5 = this.SCREEN_WIDTH;
            }
            float f3 = (float)n6 + 0.5f - this.xleft;
            float f4 = this.izadd * f3 + this.zleft;
            n6 += n;
            n5 += n;
            while (n6 < n5) {
                if (this.noDepthTest || f4 <= this.m_zbuffer[n6]) {
                    this.m_zbuffer[n6] = f4;
                    this.m_pixels[n6] = n3;
                    this.m_stencil[n6] = n4;
                }
                f4 += this.izadd;
                ++n6;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.zleft += this.zleftadd;
        }
    }

    private void drawsegment_plain_alpha(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_fill & 0xFF0000;
        int n4 = this.m_fill & 0xFF00;
        int n5 = this.m_fill & 0xFF;
        int n6 = this.m_index;
        float f3 = this.iaadd;
        while (n < n2) {
            int n7;
            int n8 = (int)(this.xleft + 0.5f);
            if (n8 < 0) {
                n8 = 0;
            }
            if ((n7 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n7 = this.SCREEN_WIDTH;
            }
            float f4 = (float)n8 + 0.5f - this.xleft;
            float f5 = this.izadd * f4 + this.zleft;
            int n9 = (int)(f3 * f4 + this.aleft);
            n8 += n;
            n7 += n;
            while (n8 < n7) {
                if (this.noDepthTest || f5 <= this.m_zbuffer[n8]) {
                    int n10 = n9 >> 16;
                    int n11 = this.m_pixels[n8];
                    int n12 = n11 & 0xFF00;
                    int n13 = n11 & 0xFF;
                    n11 &= 0xFF0000;
                    n11 += (n3 - n11) * n10 >> 8;
                    n12 += (n4 - n12) * n10 >> 8;
                    n13 += (n5 - n13) * n10 >> 8;
                    this.m_pixels[n8] = 0xFF000000 | n11 & 0xFF0000 | n12 & 0xFF00 | n13 & 0xFF;
                    this.m_stencil[n8] = n6;
                }
                f5 += this.izadd;
                n9 += this.iaadd;
                ++n8;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.zleft += this.zleftadd;
        }
    }

    private void drawsegment_gouraud(float f, float f2, int n, int n2) {
        float f3 = this.iradd;
        float f4 = this.igadd;
        float f5 = this.ibadd;
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        while (n < n2) {
            int n4;
            int n5 = (int)(this.xleft + 0.5f);
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n4 = this.SCREEN_WIDTH;
            }
            float f6 = (float)n5 + 0.5f - this.xleft;
            int n6 = (int)(f3 * f6 + this.rleft);
            int n7 = (int)(f4 * f6 + this.gleft);
            int n8 = (int)(f5 * f6 + this.bleft);
            float f7 = this.izadd * f6 + this.zleft;
            n5 += n;
            n4 += n;
            while (n5 < n4) {
                if (this.noDepthTest || f7 <= this.m_zbuffer[n5]) {
                    this.m_zbuffer[n5] = f7;
                    this.m_pixels[n5] = 0xFF000000 | (n6 & 0xFF0000 | n7 >> 8 & 0xFF00 | n8 >> 16);
                    this.m_stencil[n5] = n3;
                }
                n6 += this.iradd;
                n7 += this.igadd;
                n8 += this.ibadd;
                f7 += this.izadd;
                ++n5;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private void drawsegment_gouraud_alpha(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iradd;
        float f4 = this.igadd;
        float f5 = this.ibadd;
        float f6 = this.iaadd;
        while (n < n2) {
            int n4;
            int n5 = (int)(this.xleft + 0.5f);
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)(this.xrght + 0.5f)) > this.SCREEN_WIDTH) {
                n4 = this.SCREEN_WIDTH;
            }
            float f7 = (float)n5 + 0.5f - this.xleft;
            int n6 = (int)(f3 * f7 + this.rleft);
            int n7 = (int)(f4 * f7 + this.gleft);
            int n8 = (int)(f5 * f7 + this.bleft);
            int n9 = (int)(f6 * f7 + this.aleft);
            float f8 = this.izadd * f7 + this.zleft;
            n5 += n;
            n4 += n;
            while (n5 < n4) {
                if (this.noDepthTest || f8 <= this.m_zbuffer[n5]) {
                    int n10 = n6 & 0xFF0000;
                    int n11 = n7 >> 8 & 0xFF00;
                    int n12 = n8 >> 16;
                    int n13 = this.m_pixels[n5];
                    int n14 = n13 & 0xFF0000;
                    int n15 = n13 & 0xFF00;
                    int n16 = n9 >> 16;
                    this.m_pixels[n5] = 0xFF000000 | n14 + ((n10 - n14) * n16 >> 8) & 0xFF0000 | n15 + ((n11 - n15) * n16 >> 8) & 0xFF00 | (n13 &= 0xFF) + ((n12 - n13) * n16 >> 8) & 0xFF;
                    this.m_stencil[n5] = n3;
                }
                n6 += this.iradd;
                n7 += this.igadd;
                n8 += this.ibadd;
                n9 += this.iaadd;
                f8 += this.izadd;
                ++n5;
            }
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.aleft += this.aleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private void drawsegment_texture8(float f, float f2, int n, int n2) {
        int n3 = n;
        int n4 = this.m_texture.length - this.TEX_WIDTH - 2;
        boolean bl = this.parent.hints[9];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n5 = TEX_INTERP_POWER;
        int n6 = 1 << n5;
        if (bl) {
            if (this.precomputeAccurateTexturing()) {
                this.newax *= (float)n6;
                this.newbx *= (float)n6;
                this.newcx *= (float)n6;
                f5 = this.nearPlaneDepth;
                this.firstSegment = false;
            } else {
                bl = false;
            }
        }
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n7 = this.m_index;
        float f9 = this.iuadd;
        float f10 = this.ivadd;
        int n8 = this.m_fill & 0xFF0000;
        int n9 = this.m_fill & 0xFF00;
        int n10 = this.m_fill & 0xFF;
        while (n < n2) {
            int n11;
            int n12;
            int n13 = (int)(this.xleft + 0.5f);
            if (n13 < 0) {
                n13 = 0;
            }
            int n14 = n13;
            int n15 = (int)(this.xrght + 0.5f);
            if (n15 > this.SCREEN_WIDTH) {
                n15 = this.SCREEN_WIDTH;
            }
            float f11 = (float)n13 + 0.5f - this.xleft;
            int n16 = (int)(f9 * f11 + this.uleft);
            int n17 = (int)(f10 * f11 + this.vleft);
            float f12 = this.izadd * f11 + this.zleft;
            n13 += n;
            n15 += n;
            if (bl) {
                f3 = this.xmult * ((float)n14 + 0.5f - (float)this.SCREEN_WIDTH / 2.0f);
                f4 = this.ymult * ((float)n3 + 0.5f - (float)this.SCREEN_HEIGHT / 2.0f);
                f6 = f3 * this.ax + f4 * this.ay + f5 * this.az;
                f7 = f3 * this.bx + f4 * this.by + f5 * this.bz;
                f8 = f3 * this.cx + f4 * this.cy + f5 * this.cz;
            }
            boolean bl2 = this.newcx > 0.0f != f8 > 0.0f;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            float f13 = 0.0f;
            float f14 = 0.0f;
            float f15 = 0.0f;
            float f16 = 0.0f;
            if (bl && bl2) {
                n12 = (n15 - n13 - 1) % n6;
                n11 = n6 - n12;
                float f17 = (float)n12 / (float)n6;
                float f18 = (float)n11 / (float)n6;
                n18 = n11;
                float f19 = f6 - f18 * this.newax;
                float f20 = f7 - f18 * this.newbx;
                float f21 = f8 - f18 * this.newcx;
                float f22 = 65536.0f / f21;
                f15 = f19 * f22;
                f16 = f20 * f22;
                f22 = 65536.0f / (f8 += f17 * this.newcx);
                f13 = (f6 += f17 * this.newax) * f22;
                f14 = (f7 += f17 * this.newbx) * f22;
                n19 = (int)(f13 - f15) >> n5;
                n20 = (int)(f14 - f16) >> n5;
                n16 = (int)f15 + (n11 - 1) * n19;
                n17 = (int)f16 + (n11 - 1) * n20;
            } else {
                float f23 = 65536.0f / f8;
                f13 = f6 * f23;
                f14 = f7 * f23;
            }
            while (n13 < n15) {
                if (bl) {
                    if (n18 == n6) {
                        n18 = 0;
                    }
                    if (n18 == 0) {
                        float f24 = 65536.0f / (f8 += this.newcx);
                        f15 = f13;
                        f16 = f14;
                        f13 = (f6 += this.newax) * f24;
                        f14 = (f7 += this.newbx) * f24;
                        n16 = (int)f15;
                        n17 = (int)f16;
                        n19 = (int)(f13 - f15) >> n5;
                        n20 = (int)(f14 - f16) >> n5;
                    } else {
                        n16 += n19;
                        n17 += n20;
                    }
                    ++n18;
                }
                try {
                    if (this.noDepthTest || f12 <= this.m_zbuffer[n13]) {
                        if (this.m_bilinear) {
                            n11 = (n17 >> 16) * this.TEX_WIDTH + (n16 >> 16);
                            int n21 = n16 & 0xFFFF;
                            n12 = this.m_texture[n11] & 0xFF;
                            int n22 = this.m_texture[n11 + 1] & 0xFF;
                            if (n11 < n4) {
                                n11 += this.TEX_WIDTH;
                            }
                            int n23 = this.m_texture[n11] & 0xFF;
                            int n24 = this.m_texture[n11 + 1] & 0xFF;
                            n12 += (n22 - n12) * n21 >> 16;
                            n23 += (n24 - n23) * n21 >> 16;
                            n12 += (n23 - n12) * (n17 & 0xFFFF) >> 16;
                        } else {
                            n12 = this.m_texture[(n17 >> 16) * this.TEX_WIDTH + (n16 >> 16)] & 0xFF;
                        }
                        n11 = this.m_pixels[n13];
                        int n25 = n11 & 0xFF00;
                        int n26 = n11 & 0xFF;
                        this.m_pixels[n13] = 0xFF000000 | (n11 &= 0xFF0000) + ((n8 - n11) * n12 >> 8) & 0xFF0000 | n25 + ((n9 - n25) * n12 >> 8) & 0xFF00 | n26 + ((n10 - n26) * n12 >> 8) & 0xFF;
                        this.m_stencil[n13] = n7;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n14;
                if (!bl) {
                    n16 += this.iuadd;
                    n17 += this.ivadd;
                }
                f12 += this.izadd;
                ++n13;
            }
            ++n3;
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private void drawsegment_texture8_alpha(float f, float f2, int n, int n2) {
        int n3 = n;
        int n4 = this.m_texture.length - this.TEX_WIDTH - 2;
        boolean bl = this.parent.hints[9];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n5 = TEX_INTERP_POWER;
        int n6 = 1 << n5;
        if (bl) {
            if (this.precomputeAccurateTexturing()) {
                this.newax *= (float)n6;
                this.newbx *= (float)n6;
                this.newcx *= (float)n6;
                f5 = this.nearPlaneDepth;
                this.firstSegment = false;
            } else {
                bl = false;
            }
        }
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n7 = this.m_index;
        float f9 = this.iuadd;
        float f10 = this.ivadd;
        float f11 = this.iaadd;
        int n8 = this.m_fill & 0xFF0000;
        int n9 = this.m_fill & 0xFF00;
        int n10 = this.m_fill & 0xFF;
        while (n < n2) {
            int n11;
            int n12;
            int n13 = (int)(this.xleft + 0.5f);
            if (n13 < 0) {
                n13 = 0;
            }
            int n14 = n13;
            int n15 = (int)(this.xrght + 0.5f);
            if (n15 > this.SCREEN_WIDTH) {
                n15 = this.SCREEN_WIDTH;
            }
            float f12 = (float)n13 + 0.5f - this.xleft;
            int n16 = (int)(f9 * f12 + this.uleft);
            int n17 = (int)(f10 * f12 + this.vleft);
            int n18 = (int)(f11 * f12 + this.aleft);
            float f13 = this.izadd * f12 + this.zleft;
            n13 += n;
            n15 += n;
            if (bl) {
                f3 = this.xmult * ((float)n14 + 0.5f - (float)this.SCREEN_WIDTH / 2.0f);
                f4 = this.ymult * ((float)n3 + 0.5f - (float)this.SCREEN_HEIGHT / 2.0f);
                f6 = f3 * this.ax + f4 * this.ay + f5 * this.az;
                f7 = f3 * this.bx + f4 * this.by + f5 * this.bz;
                f8 = f3 * this.cx + f4 * this.cy + f5 * this.cz;
            }
            boolean bl2 = this.newcx > 0.0f != f8 > 0.0f;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            float f14 = 0.0f;
            float f15 = 0.0f;
            float f16 = 0.0f;
            float f17 = 0.0f;
            if (bl && bl2) {
                n12 = (n15 - n13 - 1) % n6;
                n11 = n6 - n12;
                float f18 = (float)n12 / (float)n6;
                float f19 = (float)n11 / (float)n6;
                n19 = n11;
                float f20 = f6 - f19 * this.newax;
                float f21 = f7 - f19 * this.newbx;
                float f22 = f8 - f19 * this.newcx;
                float f23 = 65536.0f / f22;
                f16 = f20 * f23;
                f17 = f21 * f23;
                f23 = 65536.0f / (f8 += f18 * this.newcx);
                f14 = (f6 += f18 * this.newax) * f23;
                f15 = (f7 += f18 * this.newbx) * f23;
                n20 = (int)(f14 - f16) >> n5;
                n21 = (int)(f15 - f17) >> n5;
                n16 = (int)f16 + (n11 - 1) * n20;
                n17 = (int)f17 + (n11 - 1) * n21;
            } else {
                float f24 = 65536.0f / f8;
                f14 = f6 * f24;
                f15 = f7 * f24;
            }
            while (n13 < n15) {
                if (bl) {
                    if (n19 == n6) {
                        n19 = 0;
                    }
                    if (n19 == 0) {
                        float f25 = 65536.0f / (f8 += this.newcx);
                        f16 = f14;
                        f17 = f15;
                        f14 = (f6 += this.newax) * f25;
                        f15 = (f7 += this.newbx) * f25;
                        n16 = (int)f16;
                        n17 = (int)f17;
                        n20 = (int)(f14 - f16) >> n5;
                        n21 = (int)(f15 - f17) >> n5;
                    } else {
                        n16 += n20;
                        n17 += n21;
                    }
                    ++n19;
                }
                try {
                    if (this.noDepthTest || f13 <= this.m_zbuffer[n13]) {
                        if (this.m_bilinear) {
                            n11 = (n17 >> 16) * this.TEX_WIDTH + (n16 >> 16);
                            int n22 = n16 & 0xFFFF;
                            n12 = this.m_texture[n11] & 0xFF;
                            int n23 = this.m_texture[n11 + 1] & 0xFF;
                            if (n11 < n4) {
                                n11 += this.TEX_WIDTH;
                            }
                            int n24 = this.m_texture[n11] & 0xFF;
                            int n25 = this.m_texture[n11 + 1] & 0xFF;
                            n12 += (n23 - n12) * n22 >> 16;
                            n24 += (n25 - n24) * n22 >> 16;
                            n12 += (n24 - n12) * (n17 & 0xFFFF) >> 16;
                        } else {
                            n12 = this.m_texture[(n17 >> 16) * this.TEX_WIDTH + (n16 >> 16)] & 0xFF;
                        }
                        n12 = n12 * (n18 >> 16) >> 8;
                        n11 = this.m_pixels[n13];
                        int n26 = n11 & 0xFF00;
                        int n27 = n11 & 0xFF;
                        this.m_pixels[n13] = 0xFF000000 | (n11 &= 0xFF0000) + ((n8 - n11) * n12 >> 8) & 0xFF0000 | n26 + ((n9 - n26) * n12 >> 8) & 0xFF00 | n27 + ((n10 - n27) * n12 >> 8) & 0xFF;
                        this.m_stencil[n13] = n7;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n14;
                if (!bl) {
                    n16 += this.iuadd;
                    n17 += this.ivadd;
                }
                f13 += this.izadd;
                n18 += this.iaadd;
                ++n13;
            }
            ++n3;
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.zleft += this.zleftadd;
            this.aleft += this.aleftadd;
        }
    }

    private void drawsegment_texture24(float f, float f2, int n, int n2) {
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n3 = this.m_index;
        float f3 = this.iuadd;
        float f4 = this.ivadd;
        boolean bl = (this.m_fill & 0xFFFFFF) != 0xFFFFFF;
        int n4 = this.m_fill >> 16 & 0xFF;
        int n5 = this.m_fill >> 8 & 0xFF;
        int n6 = this.m_fill & 0xFF;
        int n7 = n / this.SCREEN_WIDTH;
        int n8 = this.m_texture.length - this.TEX_WIDTH - 2;
        boolean bl2 = this.parent.hints[9];
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        int n9 = TEX_INTERP_POWER;
        int n10 = 1 << n9;
        if (bl2) {
            if (this.precomputeAccurateTexturing()) {
                this.newax *= (float)n10;
                this.newbx *= (float)n10;
                this.newcx *= (float)n10;
                f7 = this.nearPlaneDepth;
                this.firstSegment = false;
            } else {
                bl2 = false;
            }
        }
        while (n < n2) {
            int n11;
            int n12;
            int n13 = (int)(this.xleft + 0.5f);
            if (n13 < 0) {
                n13 = 0;
            }
            int n14 = n13;
            int n15 = (int)(this.xrght + 0.5f);
            if (n15 > this.SCREEN_WIDTH) {
                n15 = this.SCREEN_WIDTH;
            }
            float f11 = (float)n13 + 0.5f - this.xleft;
            int n16 = (int)(f3 * f11 + this.uleft);
            int n17 = (int)(f4 * f11 + this.vleft);
            float f12 = this.izadd * f11 + this.zleft;
            n13 += n;
            n15 += n;
            if (bl2) {
                f5 = this.xmult * ((float)n14 + 0.5f - (float)this.SCREEN_WIDTH / 2.0f);
                f6 = this.ymult * ((float)n7 + 0.5f - (float)this.SCREEN_HEIGHT / 2.0f);
                f8 = f5 * this.ax + f6 * this.ay + f7 * this.az;
                f9 = f5 * this.bx + f6 * this.by + f7 * this.bz;
                f10 = f5 * this.cx + f6 * this.cy + f7 * this.cz;
            }
            boolean bl3 = this.newcx > 0.0f != f10 > 0.0f;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            float f13 = 0.0f;
            float f14 = 0.0f;
            float f15 = 0.0f;
            float f16 = 0.0f;
            if (bl2 && bl3) {
                n12 = (n15 - n13 - 1) % n10;
                n11 = n10 - n12;
                float f17 = (float)n12 / (float)n10;
                float f18 = (float)n11 / (float)n10;
                n18 = n11;
                float f19 = f8 - f18 * this.newax;
                float f20 = f9 - f18 * this.newbx;
                float f21 = f10 - f18 * this.newcx;
                float f22 = 65536.0f / f21;
                f15 = f19 * f22;
                f16 = f20 * f22;
                f22 = 65536.0f / (f10 += f17 * this.newcx);
                f13 = (f8 += f17 * this.newax) * f22;
                f14 = (f9 += f17 * this.newbx) * f22;
                n19 = (int)(f13 - f15) >> n9;
                n20 = (int)(f14 - f16) >> n9;
                n16 = (int)f15 + (n11 - 1) * n19;
                n17 = (int)f16 + (n11 - 1) * n20;
            } else {
                float f23 = 65536.0f / f10;
                f13 = f8 * f23;
                f14 = f9 * f23;
            }
            while (n13 < n15) {
                if (bl2) {
                    if (n18 == n10) {
                        n18 = 0;
                    }
                    if (n18 == 0) {
                        float f24 = 65536.0f / (f10 += this.newcx);
                        f15 = f13;
                        f16 = f14;
                        f13 = (f8 += this.newax) * f24;
                        f14 = (f9 += this.newbx) * f24;
                        n16 = (int)f15;
                        n17 = (int)f16;
                        n19 = (int)(f13 - f15) >> n9;
                        n20 = (int)(f14 - f16) >> n9;
                    } else {
                        n16 += n19;
                        n17 += n20;
                    }
                    ++n18;
                }
                try {
                    if (this.noDepthTest || f12 <= this.m_zbuffer[n13]) {
                        this.m_zbuffer[n13] = f12;
                        if (this.m_bilinear) {
                            n12 = (n17 >> 16) * this.TEX_WIDTH + (n16 >> 16);
                            n11 = (n16 & 0xFFFF) >> 9;
                            int n21 = (n17 & 0xFFFF) >> 9;
                            int n22 = this.m_texture[n12];
                            int n23 = this.m_texture[n12 + 1];
                            if (n12 < n8) {
                                n12 += this.TEX_WIDTH;
                            }
                            int n24 = this.m_texture[n12];
                            int n25 = this.m_texture[n12 + 1];
                            int n26 = n22 & 0xFF0000;
                            int n27 = n24 & 0xFF0000;
                            int n28 = n26 + (((n23 & 0xFF0000) - n26) * n11 >> 7);
                            int n29 = n27 + (((n25 & 0xFF0000) - n27) * n11 >> 7);
                            int n30 = n28 + ((n29 - n28) * n21 >> 7);
                            if (bl) {
                                n30 = n30 * n4 >> 8 & 0xFF0000;
                            }
                            n26 = n22 & 0xFF00;
                            n27 = n24 & 0xFF00;
                            n28 = n26 + (((n23 & 0xFF00) - n26) * n11 >> 7);
                            n29 = n27 + (((n25 & 0xFF00) - n27) * n11 >> 7);
                            int n31 = n28 + ((n29 - n28) * n21 >> 7);
                            if (bl) {
                                n31 = n31 * n5 >> 8 & 0xFF00;
                            }
                            n26 = n22 & 0xFF;
                            n27 = n24 & 0xFF;
                            n28 = n26 + (((n23 & 0xFF) - n26) * n11 >> 7);
                            n29 = n27 + (((n25 & 0xFF) - n27) * n11 >> 7);
                            int n32 = n28 + ((n29 - n28) * n21 >> 7);
                            if (bl) {
                                n32 = n32 * n6 >> 8 & 0xFF;
                            }
                            this.m_pixels[n13] = 0xFF000000 | n30 & 0xFF0000 | n31 & 0xFF00 | n32 & 0xFF;
                        } else {
                            this.m_pixels[n13] = this.m_texture[(n17 >> 16) * this.TEX_WIDTH + (n16 >> 16)];
                        }
                        this.m_stencil[n13] = n3;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                f12 += this.izadd;
                ++n14;
                if (!bl2) {
                    n16 += this.iuadd;
                    n17 += this.ivadd;
                }
                ++n13;
            }
            ++n7;
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.zleft += this.zleftadd;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
        }
    }

    private void drawsegment_texture24_alpha(float f, float f2, int n, int n2) {
        int n3 = n;
        int n4 = this.m_texture.length - this.TEX_WIDTH - 2;
        boolean bl = this.parent.hints[9];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n5 = TEX_INTERP_POWER;
        int n6 = 1 << n5;
        if (bl) {
            if (this.precomputeAccurateTexturing()) {
                this.newax *= (float)n6;
                this.newbx *= (float)n6;
                this.newcx *= (float)n6;
                f5 = this.nearPlaneDepth;
                this.firstSegment = false;
            } else {
                bl = false;
            }
        }
        boolean bl2 = (this.m_fill & 0xFFFFFF) != 0xFFFFFF;
        int n7 = this.m_fill >> 16 & 0xFF;
        int n8 = this.m_fill >> 8 & 0xFF;
        int n9 = this.m_fill & 0xFF;
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n10 = this.m_index;
        float f9 = this.iuadd;
        float f10 = this.ivadd;
        float f11 = this.iaadd;
        while (n < n2) {
            int n11;
            int n12;
            int n13 = (int)(this.xleft + 0.5f);
            if (n13 < 0) {
                n13 = 0;
            }
            int n14 = n13;
            int n15 = (int)(this.xrght + 0.5f);
            if (n15 > this.SCREEN_WIDTH) {
                n15 = this.SCREEN_WIDTH;
            }
            float f12 = (float)n13 + 0.5f - this.xleft;
            int n16 = (int)(f9 * f12 + this.uleft);
            int n17 = (int)(f10 * f12 + this.vleft);
            int n18 = (int)(f11 * f12 + this.aleft);
            float f13 = this.izadd * f12 + this.zleft;
            n13 += n;
            n15 += n;
            if (bl) {
                f3 = this.xmult * ((float)n14 + 0.5f - (float)this.SCREEN_WIDTH / 2.0f);
                f4 = this.ymult * ((float)n3 + 0.5f - (float)this.SCREEN_HEIGHT / 2.0f);
                f6 = f3 * this.ax + f4 * this.ay + f5 * this.az;
                f7 = f3 * this.bx + f4 * this.by + f5 * this.bz;
                f8 = f3 * this.cx + f4 * this.cy + f5 * this.cz;
            }
            boolean bl3 = this.newcx > 0.0f != f8 > 0.0f;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            float f14 = 0.0f;
            float f15 = 0.0f;
            float f16 = 0.0f;
            float f17 = 0.0f;
            if (bl && bl3) {
                n12 = (n15 - n13 - 1) % n6;
                n11 = n6 - n12;
                float f18 = (float)n12 / (float)n6;
                float f19 = (float)n11 / (float)n6;
                n19 = n11;
                float f20 = f6 - f19 * this.newax;
                float f21 = f7 - f19 * this.newbx;
                float f22 = f8 - f19 * this.newcx;
                float f23 = 65536.0f / f22;
                f16 = f20 * f23;
                f17 = f21 * f23;
                f23 = 65536.0f / (f8 += f18 * this.newcx);
                f14 = (f6 += f18 * this.newax) * f23;
                f15 = (f7 += f18 * this.newbx) * f23;
                n20 = (int)(f14 - f16) >> n5;
                n21 = (int)(f15 - f17) >> n5;
                n16 = (int)f16 + (n11 - 1) * n20;
                n17 = (int)f17 + (n11 - 1) * n21;
            } else {
                float f24 = 65536.0f / f8;
                f14 = f6 * f24;
                f15 = f7 * f24;
            }
            while (n13 < n15) {
                if (bl) {
                    if (n19 == n6) {
                        n19 = 0;
                    }
                    if (n19 == 0) {
                        float f25 = 65536.0f / (f8 += this.newcx);
                        f16 = f14;
                        f17 = f15;
                        f14 = (f6 += this.newax) * f25;
                        f15 = (f7 += this.newbx) * f25;
                        n16 = (int)f16;
                        n17 = (int)f17;
                        n20 = (int)(f14 - f16) >> n5;
                        n21 = (int)(f15 - f17) >> n5;
                    } else {
                        n16 += n20;
                        n17 += n21;
                    }
                    ++n19;
                }
                try {
                    if (this.noDepthTest || f13 <= this.m_zbuffer[n13]) {
                        int n22;
                        int n23;
                        int n24;
                        int n25;
                        int n26;
                        n12 = n18 >> 16;
                        if (this.m_bilinear) {
                            n11 = (n17 >> 16) * this.TEX_WIDTH + (n16 >> 16);
                            n26 = (n16 & 0xFFFF) >> 9;
                            n25 = (n17 & 0xFFFF) >> 9;
                            n24 = this.m_texture[n11];
                            n23 = this.m_texture[n11 + 1];
                            if (n11 < n4) {
                                n11 += this.TEX_WIDTH;
                            }
                            n22 = this.m_texture[n11];
                            int n27 = this.m_texture[n11 + 1];
                            int n28 = n24 & 0xFF0000;
                            int n29 = n22 & 0xFF0000;
                            int n30 = n28 + (((n23 & 0xFF0000) - n28) * n26 >> 7);
                            int n31 = n29 + (((n27 & 0xFF0000) - n29) * n26 >> 7);
                            int n32 = n30 + ((n31 - n30) * n25 >> 7);
                            if (bl2) {
                                n32 = n32 * n7 >> 8 & 0xFF0000;
                            }
                            n28 = n24 & 0xFF00;
                            n29 = n22 & 0xFF00;
                            n30 = n28 + (((n23 & 0xFF00) - n28) * n26 >> 7);
                            n31 = n29 + (((n27 & 0xFF00) - n29) * n26 >> 7);
                            int n33 = n30 + ((n31 - n30) * n25 >> 7);
                            if (bl2) {
                                n33 = n33 * n8 >> 8 & 0xFF00;
                            }
                            n28 = n24 & 0xFF;
                            n29 = n22 & 0xFF;
                            n30 = n28 + (((n23 & 0xFF) - n28) * n26 >> 7);
                            n31 = n29 + (((n27 & 0xFF) - n29) * n26 >> 7);
                            int n34 = n30 + ((n31 - n30) * n25 >> 7);
                            if (bl2) {
                                n34 = n34 * n9 >> 8 & 0xFF;
                            }
                            int n35 = this.m_pixels[n13];
                            int n36 = n35 & 0xFF0000;
                            int n37 = n35 & 0xFF00;
                            this.m_pixels[n13] = 0xFF000000 | n36 + ((n32 - n36) * n12 >> 8) & 0xFF0000 | n37 + ((n33 - n37) * n12 >> 8) & 0xFF00 | (n35 &= 0xFF) + ((n34 - n35) * n12 >> 8) & 0xFF;
                        } else {
                            n11 = this.m_texture[(n17 >> 16) * this.TEX_WIDTH + (n16 >> 16)];
                            n26 = n11 & 0xFF00;
                            n25 = n11 & 0xFF;
                            n24 = this.m_pixels[n13];
                            n23 = n24 & 0xFF0000;
                            n22 = n24 & 0xFF00;
                            this.m_pixels[n13] = 0xFF000000 | n23 + (((n11 &= 0xFF0000) - n23) * n12 >> 8) & 0xFF0000 | n22 + ((n26 - n22) * n12 >> 8) & 0xFF00 | (n24 &= 0xFF) + ((n25 - n24) * n12 >> 8) & 0xFF;
                        }
                        this.m_stencil[n13] = n10;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n14;
                if (!bl) {
                    n16 += this.iuadd;
                    n17 += this.ivadd;
                }
                n18 += this.iaadd;
                f13 += this.izadd;
                ++n13;
            }
            ++n3;
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.zleft += this.zleftadd;
            this.aleft += this.aleftadd;
        }
    }

    private void drawsegment_texture32(float f, float f2, int n, int n2) {
        int n3 = n;
        int n4 = this.m_texture.length - this.TEX_WIDTH - 2;
        boolean bl = this.parent.hints[9];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n5 = TEX_INTERP_POWER;
        int n6 = 1 << n5;
        if (bl) {
            if (this.precomputeAccurateTexturing()) {
                this.newax *= (float)n6;
                this.newbx *= (float)n6;
                this.newcx *= (float)n6;
                f5 = this.nearPlaneDepth;
                this.firstSegment = false;
            } else {
                bl = false;
            }
        }
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n7 = this.m_index;
        boolean bl2 = this.m_fill != -1;
        int n8 = this.m_fill >> 16 & 0xFF;
        int n9 = this.m_fill >> 8 & 0xFF;
        int n10 = this.m_fill & 0xFF;
        float f9 = this.iuadd;
        float f10 = this.ivadd;
        while (n < n2) {
            int n11;
            int n12;
            int n13 = (int)(this.xleft + 0.5f);
            if (n13 < 0) {
                n13 = 0;
            }
            int n14 = n13;
            int n15 = (int)(this.xrght + 0.5f);
            if (n15 > this.SCREEN_WIDTH) {
                n15 = this.SCREEN_WIDTH;
            }
            float f11 = (float)n13 + 0.5f - this.xleft;
            int n16 = (int)(f9 * f11 + this.uleft);
            int n17 = (int)(f10 * f11 + this.vleft);
            float f12 = this.izadd * f11 + this.zleft;
            n13 += n;
            n15 += n;
            if (bl) {
                f3 = this.xmult * ((float)n14 + 0.5f - (float)this.SCREEN_WIDTH / 2.0f);
                f4 = this.ymult * ((float)n3 + 0.5f - (float)this.SCREEN_HEIGHT / 2.0f);
                f6 = f3 * this.ax + f4 * this.ay + f5 * this.az;
                f7 = f3 * this.bx + f4 * this.by + f5 * this.bz;
                f8 = f3 * this.cx + f4 * this.cy + f5 * this.cz;
            }
            boolean bl3 = this.newcx > 0.0f != f8 > 0.0f;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            float f13 = 0.0f;
            float f14 = 0.0f;
            float f15 = 0.0f;
            float f16 = 0.0f;
            if (bl && bl3) {
                n12 = (n15 - n13 - 1) % n6;
                n11 = n6 - n12;
                float f17 = (float)n12 / (float)n6;
                float f18 = (float)n11 / (float)n6;
                n18 = n11;
                float f19 = f6 - f18 * this.newax;
                float f20 = f7 - f18 * this.newbx;
                float f21 = f8 - f18 * this.newcx;
                float f22 = 65536.0f / f21;
                f15 = f19 * f22;
                f16 = f20 * f22;
                f22 = 65536.0f / (f8 += f17 * this.newcx);
                f13 = (f6 += f17 * this.newax) * f22;
                f14 = (f7 += f17 * this.newbx) * f22;
                n19 = (int)(f13 - f15) >> n5;
                n20 = (int)(f14 - f16) >> n5;
                n16 = (int)f15 + (n11 - 1) * n19;
                n17 = (int)f16 + (n11 - 1) * n20;
            } else {
                float f23 = 65536.0f / f8;
                f13 = f6 * f23;
                f14 = f7 * f23;
            }
            while (n13 < n15) {
                if (bl) {
                    if (n18 == n6) {
                        n18 = 0;
                    }
                    if (n18 == 0) {
                        float f24 = 65536.0f / (f8 += this.newcx);
                        f15 = f13;
                        f16 = f14;
                        f13 = (f6 += this.newax) * f24;
                        f14 = (f7 += this.newbx) * f24;
                        n16 = (int)f15;
                        n17 = (int)f16;
                        n19 = (int)(f13 - f15) >> n5;
                        n20 = (int)(f14 - f16) >> n5;
                    } else {
                        n16 += n19;
                        n17 += n20;
                    }
                    ++n18;
                }
                try {
                    if (this.noDepthTest || f12 <= this.m_zbuffer[n13]) {
                        int n21;
                        int n22;
                        int n23;
                        int n24;
                        int n25;
                        if (this.m_bilinear) {
                            n12 = (n17 >> 16) * this.TEX_WIDTH + (n16 >> 16);
                            n11 = (n16 & 0xFFFF) >> 9;
                            n25 = (n17 & 0xFFFF) >> 9;
                            n24 = this.m_texture[n12];
                            n23 = this.m_texture[n12 + 1];
                            if (n12 < n4) {
                                n12 += this.TEX_WIDTH;
                            }
                            n22 = this.m_texture[n12];
                            n21 = this.m_texture[n12 + 1];
                            int n26 = n24 & 0xFF0000;
                            int n27 = n22 & 0xFF0000;
                            int n28 = n26 + (((n23 & 0xFF0000) - n26) * n11 >> 7);
                            int n29 = n27 + (((n21 & 0xFF0000) - n27) * n11 >> 7);
                            int n30 = n28 + ((n29 - n28) * n25 >> 7);
                            if (bl2) {
                                n30 = n30 * n8 >> 8 & 0xFF0000;
                            }
                            n26 = n24 & 0xFF00;
                            n27 = n22 & 0xFF00;
                            n28 = n26 + (((n23 & 0xFF00) - n26) * n11 >> 7);
                            n29 = n27 + (((n21 & 0xFF00) - n27) * n11 >> 7);
                            int n31 = n28 + ((n29 - n28) * n25 >> 7);
                            if (bl2) {
                                n31 = n31 * n9 >> 8 & 0xFF00;
                            }
                            n26 = n24 & 0xFF;
                            n27 = n22 & 0xFF;
                            n28 = n26 + (((n23 & 0xFF) - n26) * n11 >> 7);
                            n29 = n27 + (((n21 & 0xFF) - n27) * n11 >> 7);
                            int n32 = n28 + ((n29 - n28) * n25 >> 7);
                            if (bl2) {
                                n32 = n32 * n10 >> 8 & 0xFF;
                            }
                            n28 = (n24 >>>= 24) + (((n23 >>> 24) - n24) * n11 >> 7);
                            n29 = (n22 >>>= 24) + (((n21 >>> 24) - n22) * n11 >> 7);
                            int n33 = n28 + ((n29 - n28) * n25 >> 7);
                            int n34 = this.m_pixels[n13];
                            int n35 = n34 & 0xFF0000;
                            int n36 = n34 & 0xFF00;
                            this.m_pixels[n13] = 0xFF000000 | n35 + ((n30 - n35) * n33 >> 8) & 0xFF0000 | n36 + ((n31 - n36) * n33 >> 8) & 0xFF00 | (n34 &= 0xFF) + ((n32 - n34) * n33 >> 8) & 0xFF;
                        } else {
                            n12 = this.m_texture[(n17 >> 16) * this.TEX_WIDTH + (n16 >> 16)];
                            n11 = n12 >>> 24;
                            n25 = n12 & 0xFF00;
                            n24 = n12 & 0xFF;
                            n23 = this.m_pixels[n13];
                            n22 = n23 & 0xFF0000;
                            n21 = n23 & 0xFF00;
                            this.m_pixels[n13] = 0xFF000000 | n22 + (((n12 &= 0xFF0000) - n22) * n11 >> 8) & 0xFF0000 | n21 + ((n25 - n21) * n11 >> 8) & 0xFF00 | (n23 &= 0xFF) + ((n24 - n23) * n11 >> 8) & 0xFF;
                        }
                        this.m_stencil[n13] = n7;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n14;
                if (!bl) {
                    n16 += this.iuadd;
                    n17 += this.ivadd;
                }
                f12 += this.izadd;
                ++n13;
            }
            ++n3;
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.zleft += this.zleftadd;
            this.aleft += this.aleftadd;
        }
    }

    private void drawsegment_texture32_alpha(float f, float f2, int n, int n2) {
        int n3 = n;
        int n4 = this.m_texture.length - this.TEX_WIDTH - 2;
        boolean bl = this.parent.hints[9];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n5 = TEX_INTERP_POWER;
        int n6 = 1 << n5;
        if (bl) {
            if (this.precomputeAccurateTexturing()) {
                this.newax *= (float)n6;
                this.newbx *= (float)n6;
                this.newcx *= (float)n6;
                f5 = this.nearPlaneDepth;
                this.firstSegment = false;
            } else {
                bl = false;
            }
        }
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n7 = this.m_index;
        boolean bl2 = (this.m_fill & 0xFFFFFF) != 0xFFFFFF;
        int n8 = this.m_fill >> 16 & 0xFF;
        int n9 = this.m_fill >> 8 & 0xFF;
        int n10 = this.m_fill & 0xFF;
        float f9 = this.iuadd;
        float f10 = this.ivadd;
        float f11 = this.iaadd;
        while (n < n2) {
            int n11;
            int n12;
            int n13 = (int)(this.xleft + 0.5f);
            if (n13 < 0) {
                n13 = 0;
            }
            int n14 = n13;
            int n15 = (int)(this.xrght + 0.5f);
            if (n15 > this.SCREEN_WIDTH) {
                n15 = this.SCREEN_WIDTH;
            }
            float f12 = (float)n13 + 0.5f - this.xleft;
            int n16 = (int)(f9 * f12 + this.uleft);
            int n17 = (int)(f10 * f12 + this.vleft);
            int n18 = (int)(f11 * f12 + this.aleft);
            float f13 = this.izadd * f12 + this.zleft;
            n13 += n;
            n15 += n;
            if (bl) {
                f3 = this.xmult * ((float)n14 + 0.5f - (float)this.SCREEN_WIDTH / 2.0f);
                f4 = this.ymult * ((float)n3 + 0.5f - (float)this.SCREEN_HEIGHT / 2.0f);
                f6 = f3 * this.ax + f4 * this.ay + f5 * this.az;
                f7 = f3 * this.bx + f4 * this.by + f5 * this.bz;
                f8 = f3 * this.cx + f4 * this.cy + f5 * this.cz;
            }
            boolean bl3 = this.newcx > 0.0f != f8 > 0.0f;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            float f14 = 0.0f;
            float f15 = 0.0f;
            float f16 = 0.0f;
            float f17 = 0.0f;
            if (bl && bl3) {
                n12 = (n15 - n13 - 1) % n6;
                n11 = n6 - n12;
                float f18 = (float)n12 / (float)n6;
                float f19 = (float)n11 / (float)n6;
                n19 = n11;
                float f20 = f6 - f19 * this.newax;
                float f21 = f7 - f19 * this.newbx;
                float f22 = f8 - f19 * this.newcx;
                float f23 = 65536.0f / f22;
                f16 = f20 * f23;
                f17 = f21 * f23;
                f23 = 65536.0f / (f8 += f18 * this.newcx);
                f14 = (f6 += f18 * this.newax) * f23;
                f15 = (f7 += f18 * this.newbx) * f23;
                n20 = (int)(f14 - f16) >> n5;
                n21 = (int)(f15 - f17) >> n5;
                n16 = (int)f16 + (n11 - 1) * n20;
                n17 = (int)f17 + (n11 - 1) * n21;
            } else {
                float f24 = 65536.0f / f8;
                f14 = f6 * f24;
                f15 = f7 * f24;
            }
            while (n13 < n15) {
                if (bl) {
                    if (n19 == n6) {
                        n19 = 0;
                    }
                    if (n19 == 0) {
                        float f25 = 65536.0f / (f8 += this.newcx);
                        f16 = f14;
                        f17 = f15;
                        f14 = (f6 += this.newax) * f25;
                        f15 = (f7 += this.newbx) * f25;
                        n16 = (int)f16;
                        n17 = (int)f17;
                        n20 = (int)(f14 - f16) >> n5;
                        n21 = (int)(f15 - f17) >> n5;
                    } else {
                        n16 += n20;
                        n17 += n21;
                    }
                    ++n19;
                }
                try {
                    if (this.noDepthTest || f13 <= this.m_zbuffer[n13]) {
                        int n22;
                        int n23;
                        int n24;
                        int n25;
                        int n26;
                        n12 = n18 >> 16;
                        if (this.m_bilinear) {
                            n11 = (n17 >> 16) * this.TEX_WIDTH + (n16 >> 16);
                            n26 = (n16 & 0xFFFF) >> 9;
                            n25 = (n17 & 0xFFFF) >> 9;
                            n24 = this.m_texture[n11];
                            n23 = this.m_texture[n11 + 1];
                            if (n11 < n4) {
                                n11 += this.TEX_WIDTH;
                            }
                            n22 = this.m_texture[n11];
                            int n27 = this.m_texture[n11 + 1];
                            int n28 = n24 & 0xFF0000;
                            int n29 = n22 & 0xFF0000;
                            int n30 = n28 + (((n23 & 0xFF0000) - n28) * n26 >> 7);
                            int n31 = n29 + (((n27 & 0xFF0000) - n29) * n26 >> 7);
                            int n32 = n30 + ((n31 - n30) * n25 >> 7);
                            if (bl2) {
                                n32 = n32 * n8 >> 8 & 0xFF0000;
                            }
                            n28 = n24 & 0xFF00;
                            n29 = n22 & 0xFF00;
                            n30 = n28 + (((n23 & 0xFF00) - n28) * n26 >> 7);
                            n31 = n29 + (((n27 & 0xFF00) - n29) * n26 >> 7);
                            int n33 = n30 + ((n31 - n30) * n25 >> 7);
                            if (bl2) {
                                n33 = n33 * n9 >> 8 & 0xFF00;
                            }
                            n28 = n24 & 0xFF;
                            n29 = n22 & 0xFF;
                            n30 = n28 + (((n23 & 0xFF) - n28) * n26 >> 7);
                            n31 = n29 + (((n27 & 0xFF) - n29) * n26 >> 7);
                            int n34 = n30 + ((n31 - n30) * n25 >> 7);
                            if (bl2) {
                                n34 = n34 * n10 >> 8 & 0xFF;
                            }
                            n30 = (n24 >>>= 24) + (((n23 >>> 24) - n24) * n26 >> 7);
                            n31 = (n22 >>>= 24) + (((n27 >>> 24) - n22) * n26 >> 7);
                            n12 = n12 * (n30 + ((n31 - n30) * n25 >> 7)) >> 8;
                            int n35 = this.m_pixels[n13];
                            int n36 = n35 & 0xFF0000;
                            int n37 = n35 & 0xFF00;
                            this.m_pixels[n13] = 0xFF000000 | n36 + ((n32 - n36) * n12 >> 8) & 0xFF0000 | n37 + ((n33 - n37) * n12 >> 8) & 0xFF00 | (n35 &= 0xFF) + ((n34 - n35) * n12 >> 8) & 0xFF;
                        } else {
                            n11 = this.m_texture[(n17 >> 16) * this.TEX_WIDTH + (n16 >> 16)];
                            n12 = n12 * (n11 >>> 24) >> 8;
                            n26 = n11 & 0xFF00;
                            n25 = n11 & 0xFF;
                            n24 = this.m_pixels[n13];
                            n23 = n24 & 0xFF0000;
                            n22 = n24 & 0xFF00;
                            this.m_pixels[n13] = 0xFF000000 | n23 + (((n11 &= 0xFF0000) - n23) * n12 >> 8) & 0xFF0000 | n22 + ((n26 - n22) * n12 >> 8) & 0xFF00 | (n24 &= 0xFF) + ((n25 - n24) * n12 >> 8) & 0xFF;
                        }
                        this.m_stencil[n13] = n7;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n14;
                if (!bl) {
                    n16 += this.iuadd;
                    n17 += this.ivadd;
                }
                n18 += this.iaadd;
                f13 += this.izadd;
                ++n13;
            }
            ++n3;
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.zleft += this.zleftadd;
            this.aleft += this.aleftadd;
        }
    }

    private void drawsegment_gouraud_texture8(float f, float f2, int n, int n2) {
        int n3 = n;
        int n4 = this.m_texture.length - this.TEX_WIDTH - 2;
        boolean bl = this.parent.hints[9];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n5 = TEX_INTERP_POWER;
        int n6 = 1 << n5;
        if (bl) {
            if (this.precomputeAccurateTexturing()) {
                this.newax *= (float)n6;
                this.newbx *= (float)n6;
                this.newcx *= (float)n6;
                f5 = this.nearPlaneDepth;
                this.firstSegment = false;
            } else {
                bl = false;
            }
        }
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n7 = this.m_index;
        float f9 = this.iuadd;
        float f10 = this.ivadd;
        float f11 = this.iradd;
        float f12 = this.igadd;
        float f13 = this.ibadd;
        while (n < n2) {
            int n8;
            int n9;
            int n10 = (int)(this.xleft + 0.5f);
            if (n10 < 0) {
                n10 = 0;
            }
            int n11 = n10;
            int n12 = (int)(this.xrght + 0.5f);
            if (n12 > this.SCREEN_WIDTH) {
                n12 = this.SCREEN_WIDTH;
            }
            float f14 = (float)n10 + 0.5f - this.xleft;
            int n13 = (int)(f9 * f14 + this.uleft);
            int n14 = (int)(f10 * f14 + this.vleft);
            int n15 = (int)(f11 * f14 + this.rleft);
            int n16 = (int)(f12 * f14 + this.gleft);
            int n17 = (int)(f13 * f14 + this.bleft);
            float f15 = this.izadd * f14 + this.zleft;
            n10 += n;
            n12 += n;
            if (bl) {
                f3 = this.xmult * ((float)n11 + 0.5f - (float)this.SCREEN_WIDTH / 2.0f);
                f4 = this.ymult * ((float)n3 + 0.5f - (float)this.SCREEN_HEIGHT / 2.0f);
                f6 = f3 * this.ax + f4 * this.ay + f5 * this.az;
                f7 = f3 * this.bx + f4 * this.by + f5 * this.bz;
                f8 = f3 * this.cx + f4 * this.cy + f5 * this.cz;
            }
            boolean bl2 = this.newcx > 0.0f != f8 > 0.0f;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            float f16 = 0.0f;
            float f17 = 0.0f;
            float f18 = 0.0f;
            float f19 = 0.0f;
            if (bl && bl2) {
                n9 = (n12 - n10 - 1) % n6;
                n8 = n6 - n9;
                float f20 = (float)n9 / (float)n6;
                float f21 = (float)n8 / (float)n6;
                n18 = n8;
                float f22 = f6 - f21 * this.newax;
                float f23 = f7 - f21 * this.newbx;
                float f24 = f8 - f21 * this.newcx;
                float f25 = 65536.0f / f24;
                f18 = f22 * f25;
                f19 = f23 * f25;
                f25 = 65536.0f / (f8 += f20 * this.newcx);
                f16 = (f6 += f20 * this.newax) * f25;
                f17 = (f7 += f20 * this.newbx) * f25;
                n19 = (int)(f16 - f18) >> n5;
                n20 = (int)(f17 - f19) >> n5;
                n13 = (int)f18 + (n8 - 1) * n19;
                n14 = (int)f19 + (n8 - 1) * n20;
            } else {
                float f26 = 65536.0f / f8;
                f16 = f6 * f26;
                f17 = f7 * f26;
            }
            while (n10 < n12) {
                if (bl) {
                    if (n18 == n6) {
                        n18 = 0;
                    }
                    if (n18 == 0) {
                        float f27 = 65536.0f / (f8 += this.newcx);
                        f18 = f16;
                        f19 = f17;
                        f16 = (f6 += this.newax) * f27;
                        f17 = (f7 += this.newbx) * f27;
                        n13 = (int)f18;
                        n14 = (int)f19;
                        n19 = (int)(f16 - f18) >> n5;
                        n20 = (int)(f17 - f19) >> n5;
                    } else {
                        n13 += n19;
                        n14 += n20;
                    }
                    ++n18;
                }
                try {
                    if (this.noDepthTest || f15 <= this.m_zbuffer[n10]) {
                        if (this.m_bilinear) {
                            n8 = (n14 >> 16) * this.TEX_WIDTH + (n13 >> 16);
                            int n21 = n13 & 0xFFFF;
                            n9 = this.m_texture[n8] & 0xFF;
                            int n22 = this.m_texture[n8 + 1] & 0xFF;
                            if (n8 < n4) {
                                n8 += this.TEX_WIDTH;
                            }
                            int n23 = this.m_texture[n8] & 0xFF;
                            int n24 = this.m_texture[n8 + 1] & 0xFF;
                            n9 += (n22 - n9) * n21 >> 16;
                            n23 += (n24 - n23) * n21 >> 16;
                            n9 += (n23 - n9) * (n14 & 0xFFFF) >> 16;
                        } else {
                            n9 = this.m_texture[(n14 >> 16) * this.TEX_WIDTH + (n13 >> 16)] & 0xFF;
                        }
                        n8 = n15 & 0xFF0000;
                        int n25 = n16 >> 8 & 0xFF00;
                        int n26 = n17 >> 16;
                        int n27 = this.m_pixels[n10];
                        int n28 = n27 & 0xFF0000;
                        int n29 = n27 & 0xFF00;
                        this.m_pixels[n10] = 0xFF000000 | n28 + ((n8 - n28) * n9 >> 8) & 0xFF0000 | n29 + ((n25 - n29) * n9 >> 8) & 0xFF00 | (n27 &= 0xFF) + ((n26 - n27) * n9 >> 8) & 0xFF;
                        this.m_stencil[n10] = n7;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n11;
                if (!bl) {
                    n13 += this.iuadd;
                    n14 += this.ivadd;
                }
                n15 += this.iradd;
                n16 += this.igadd;
                n17 += this.ibadd;
                f15 += this.izadd;
                ++n10;
            }
            ++n3;
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private void drawsegment_gouraud_texture8_alpha(float f, float f2, int n, int n2) {
        int n3 = n;
        int n4 = this.m_texture.length - this.TEX_WIDTH - 2;
        boolean bl = this.parent.hints[9];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n5 = TEX_INTERP_POWER;
        int n6 = 1 << n5;
        if (bl) {
            if (this.precomputeAccurateTexturing()) {
                this.newax *= (float)n6;
                this.newbx *= (float)n6;
                this.newcx *= (float)n6;
                f5 = this.nearPlaneDepth;
                this.firstSegment = false;
            } else {
                bl = false;
            }
        }
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n7 = this.m_index;
        float f9 = this.iuadd;
        float f10 = this.ivadd;
        float f11 = this.iradd;
        float f12 = this.igadd;
        float f13 = this.ibadd;
        float f14 = this.iaadd;
        while (n < n2) {
            int n8;
            int n9;
            int n10 = (int)(this.xleft + 0.5f);
            if (n10 < 0) {
                n10 = 0;
            }
            int n11 = n10;
            int n12 = (int)(this.xrght + 0.5f);
            if (n12 > this.SCREEN_WIDTH) {
                n12 = this.SCREEN_WIDTH;
            }
            float f15 = (float)n10 + 0.5f - this.xleft;
            int n13 = (int)(f9 * f15 + this.uleft);
            int n14 = (int)(f10 * f15 + this.vleft);
            int n15 = (int)(f11 * f15 + this.rleft);
            int n16 = (int)(f12 * f15 + this.gleft);
            int n17 = (int)(f13 * f15 + this.bleft);
            int n18 = (int)(f14 * f15 + this.aleft);
            float f16 = this.izadd * f15 + this.zleft;
            n10 += n;
            n12 += n;
            if (bl) {
                f3 = this.xmult * ((float)n11 + 0.5f - (float)this.SCREEN_WIDTH / 2.0f);
                f4 = this.ymult * ((float)n3 + 0.5f - (float)this.SCREEN_HEIGHT / 2.0f);
                f6 = f3 * this.ax + f4 * this.ay + f5 * this.az;
                f7 = f3 * this.bx + f4 * this.by + f5 * this.bz;
                f8 = f3 * this.cx + f4 * this.cy + f5 * this.cz;
            }
            boolean bl2 = this.newcx > 0.0f != f8 > 0.0f;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            float f17 = 0.0f;
            float f18 = 0.0f;
            float f19 = 0.0f;
            float f20 = 0.0f;
            if (bl && bl2) {
                n9 = (n12 - n10 - 1) % n6;
                n8 = n6 - n9;
                float f21 = (float)n9 / (float)n6;
                float f22 = (float)n8 / (float)n6;
                n19 = n8;
                float f23 = f6 - f22 * this.newax;
                float f24 = f7 - f22 * this.newbx;
                float f25 = f8 - f22 * this.newcx;
                float f26 = 65536.0f / f25;
                f19 = f23 * f26;
                f20 = f24 * f26;
                f26 = 65536.0f / (f8 += f21 * this.newcx);
                f17 = (f6 += f21 * this.newax) * f26;
                f18 = (f7 += f21 * this.newbx) * f26;
                n20 = (int)(f17 - f19) >> n5;
                n21 = (int)(f18 - f20) >> n5;
                n13 = (int)f19 + (n8 - 1) * n20;
                n14 = (int)f20 + (n8 - 1) * n21;
            } else {
                float f27 = 65536.0f / f8;
                f17 = f6 * f27;
                f18 = f7 * f27;
            }
            while (n10 < n12) {
                if (bl) {
                    if (n19 == n6) {
                        n19 = 0;
                    }
                    if (n19 == 0) {
                        float f28 = 65536.0f / (f8 += this.newcx);
                        f19 = f17;
                        f20 = f18;
                        f17 = (f6 += this.newax) * f28;
                        f18 = (f7 += this.newbx) * f28;
                        n13 = (int)f19;
                        n14 = (int)f20;
                        n20 = (int)(f17 - f19) >> n5;
                        n21 = (int)(f18 - f20) >> n5;
                    } else {
                        n13 += n20;
                        n14 += n21;
                    }
                    ++n19;
                }
                try {
                    if (this.noDepthTest || f16 <= this.m_zbuffer[n10]) {
                        if (this.m_bilinear) {
                            n8 = (n14 >> 16) * this.TEX_WIDTH + (n13 >> 16);
                            int n22 = n13 & 0xFFFF;
                            n9 = this.m_texture[n8] & 0xFF;
                            int n23 = this.m_texture[n8 + 1] & 0xFF;
                            if (n8 < n4) {
                                n8 += this.TEX_WIDTH;
                            }
                            int n24 = this.m_texture[n8] & 0xFF;
                            int n25 = this.m_texture[n8 + 1] & 0xFF;
                            n9 += (n23 - n9) * n22 >> 16;
                            n24 += (n25 - n24) * n22 >> 16;
                            n9 += (n24 - n9) * (n14 & 0xFFFF) >> 16;
                        } else {
                            n9 = this.m_texture[(n14 >> 16) * this.TEX_WIDTH + (n13 >> 16)] & 0xFF;
                        }
                        n9 = n9 * (n18 >> 16) >> 8;
                        n8 = n15 & 0xFF0000;
                        int n26 = n16 >> 8 & 0xFF00;
                        int n27 = n17 >> 16;
                        int n28 = this.m_pixels[n10];
                        int n29 = n28 & 0xFF0000;
                        int n30 = n28 & 0xFF00;
                        this.m_pixels[n10] = 0xFF000000 | n29 + ((n8 - n29) * n9 >> 8) & 0xFF0000 | n30 + ((n26 - n30) * n9 >> 8) & 0xFF00 | (n28 &= 0xFF) + ((n27 - n28) * n9 >> 8) & 0xFF;
                        this.m_stencil[n10] = n7;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n11;
                if (!bl) {
                    n13 += this.iuadd;
                    n14 += this.ivadd;
                }
                n15 += this.iradd;
                n16 += this.igadd;
                n17 += this.ibadd;
                n18 += this.iaadd;
                f16 += this.izadd;
                ++n10;
            }
            ++n3;
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.aleft += this.aleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private void drawsegment_gouraud_texture24(float f, float f2, int n, int n2) {
        int n3 = n;
        int n4 = this.m_texture.length - this.TEX_WIDTH - 2;
        boolean bl = this.parent.hints[9];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n5 = TEX_INTERP_POWER;
        int n6 = 1 << n5;
        if (bl) {
            if (this.precomputeAccurateTexturing()) {
                this.newax *= (float)n6;
                this.newbx *= (float)n6;
                this.newcx *= (float)n6;
                f5 = this.nearPlaneDepth;
                this.firstSegment = false;
            } else {
                bl = false;
            }
        }
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n7 = this.m_index;
        float f9 = this.iuadd;
        float f10 = this.ivadd;
        float f11 = this.iradd;
        float f12 = this.igadd;
        float f13 = this.ibadd;
        while (n < n2) {
            int n8;
            int n9;
            int n10 = (int)(this.xleft + 0.5f);
            if (n10 < 0) {
                n10 = 0;
            }
            int n11 = n10;
            int n12 = (int)(this.xrght + 0.5f);
            if (n12 > this.SCREEN_WIDTH) {
                n12 = this.SCREEN_WIDTH;
            }
            float f14 = (float)n10 + 0.5f - this.xleft;
            int n13 = (int)(f9 * f14 + this.uleft);
            int n14 = (int)(f10 * f14 + this.vleft);
            int n15 = (int)(f11 * f14 + this.rleft);
            int n16 = (int)(f12 * f14 + this.gleft);
            int n17 = (int)(f13 * f14 + this.bleft);
            float f15 = this.izadd * f14 + this.zleft;
            n10 += n;
            n12 += n;
            if (bl) {
                f3 = this.xmult * ((float)n11 + 0.5f - (float)this.SCREEN_WIDTH / 2.0f);
                f4 = this.ymult * ((float)n3 + 0.5f - (float)this.SCREEN_HEIGHT / 2.0f);
                f6 = f3 * this.ax + f4 * this.ay + f5 * this.az;
                f7 = f3 * this.bx + f4 * this.by + f5 * this.bz;
                f8 = f3 * this.cx + f4 * this.cy + f5 * this.cz;
            }
            boolean bl2 = this.newcx > 0.0f != f8 > 0.0f;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            float f16 = 0.0f;
            float f17 = 0.0f;
            float f18 = 0.0f;
            float f19 = 0.0f;
            if (bl && bl2) {
                n9 = (n12 - n10 - 1) % n6;
                n8 = n6 - n9;
                float f20 = (float)n9 / (float)n6;
                float f21 = (float)n8 / (float)n6;
                n18 = n8;
                float f22 = f6 - f21 * this.newax;
                float f23 = f7 - f21 * this.newbx;
                float f24 = f8 - f21 * this.newcx;
                float f25 = 65536.0f / f24;
                f18 = f22 * f25;
                f19 = f23 * f25;
                f25 = 65536.0f / (f8 += f20 * this.newcx);
                f16 = (f6 += f20 * this.newax) * f25;
                f17 = (f7 += f20 * this.newbx) * f25;
                n19 = (int)(f16 - f18) >> n5;
                n20 = (int)(f17 - f19) >> n5;
                n13 = (int)f18 + (n8 - 1) * n19;
                n14 = (int)f19 + (n8 - 1) * n20;
            } else {
                float f26 = 65536.0f / f8;
                f16 = f6 * f26;
                f17 = f7 * f26;
            }
            while (n10 < n12) {
                if (bl) {
                    if (n18 == n6) {
                        n18 = 0;
                    }
                    if (n18 == 0) {
                        float f27 = 65536.0f / (f8 += this.newcx);
                        f18 = f16;
                        f19 = f17;
                        f16 = (f6 += this.newax) * f27;
                        f17 = (f7 += this.newbx) * f27;
                        n13 = (int)f18;
                        n14 = (int)f19;
                        n19 = (int)(f16 - f18) >> n5;
                        n20 = (int)(f17 - f19) >> n5;
                    } else {
                        n13 += n19;
                        n14 += n20;
                    }
                    ++n18;
                }
                try {
                    if (this.noDepthTest || f15 <= this.m_zbuffer[n10]) {
                        int n21;
                        this.m_zbuffer[n10] = f15;
                        if (this.m_bilinear) {
                            int n22 = (n14 >> 16) * this.TEX_WIDTH + (n13 >> 16);
                            int n23 = (n13 & 0xFFFF) >> 9;
                            int n24 = (n14 & 0xFFFF) >> 9;
                            int n25 = this.m_texture[n22];
                            int n26 = this.m_texture[n22 + 1];
                            if (n22 < n4) {
                                n22 += this.TEX_WIDTH;
                            }
                            int n27 = this.m_texture[n22];
                            int n28 = this.m_texture[n22 + 1];
                            int n29 = n25 & 0xFF0000;
                            int n30 = n27 & 0xFF0000;
                            int n31 = n29 + (((n26 & 0xFF0000) - n29) * n23 >> 7);
                            int n32 = n30 + (((n28 & 0xFF0000) - n30) * n23 >> 7);
                            n9 = n31 + ((n32 - n31) * n24 >> 7);
                            n29 = n25 & 0xFF00;
                            n30 = n27 & 0xFF00;
                            n31 = n29 + (((n26 & 0xFF00) - n29) * n23 >> 7);
                            n32 = n30 + (((n28 & 0xFF00) - n30) * n23 >> 7);
                            n8 = n31 + ((n32 - n31) * n24 >> 7);
                            n29 = n25 & 0xFF;
                            n30 = n27 & 0xFF;
                            n31 = n29 + (((n26 & 0xFF) - n29) * n23 >> 7);
                            n32 = n30 + (((n28 & 0xFF) - n30) * n23 >> 7);
                            n21 = n31 + ((n32 - n31) * n24 >> 7);
                        } else {
                            n21 = this.m_texture[(n14 >> 16) * this.TEX_WIDTH + (n13 >> 16)];
                            n9 = n21 & 0xFF0000;
                            n8 = n21 & 0xFF00;
                            n21 &= 0xFF;
                        }
                        int n33 = n15 >> 16;
                        int n34 = n16 >> 16;
                        int n35 = n17 >> 16;
                        this.m_pixels[n10] = 0xFF000000 | (n9 * n33 & 0xFF000000 | n8 * n34 & 0xFF0000 | n21 * n35) >> 8;
                        this.m_stencil[n10] = n7;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n11;
                if (!bl) {
                    n13 += this.iuadd;
                    n14 += this.ivadd;
                }
                n15 += this.iradd;
                n16 += this.igadd;
                n17 += this.ibadd;
                f15 += this.izadd;
                ++n10;
            }
            ++n3;
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private void drawsegment_gouraud_texture24_alpha(float f, float f2, int n, int n2) {
        int n3 = n;
        int n4 = this.m_texture.length - this.TEX_WIDTH - 2;
        boolean bl = this.parent.hints[9];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n5 = TEX_INTERP_POWER;
        int n6 = 1 << n5;
        if (bl) {
            if (this.precomputeAccurateTexturing()) {
                this.newax *= (float)n6;
                this.newbx *= (float)n6;
                this.newcx *= (float)n6;
                f5 = this.nearPlaneDepth;
                this.firstSegment = false;
            } else {
                bl = false;
            }
        }
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n7 = this.m_index;
        float f9 = this.iuadd;
        float f10 = this.ivadd;
        float f11 = this.iradd;
        float f12 = this.igadd;
        float f13 = this.ibadd;
        float f14 = this.iaadd;
        while (n < n2) {
            int n8;
            int n9;
            int n10 = (int)(this.xleft + 0.5f);
            if (n10 < 0) {
                n10 = 0;
            }
            int n11 = n10;
            int n12 = (int)(this.xrght + 0.5f);
            if (n12 > this.SCREEN_WIDTH) {
                n12 = this.SCREEN_WIDTH;
            }
            float f15 = (float)n10 + 0.5f - this.xleft;
            int n13 = (int)(f9 * f15 + this.uleft);
            int n14 = (int)(f10 * f15 + this.vleft);
            int n15 = (int)(f11 * f15 + this.rleft);
            int n16 = (int)(f12 * f15 + this.gleft);
            int n17 = (int)(f13 * f15 + this.bleft);
            int n18 = (int)(f14 * f15 + this.aleft);
            float f16 = this.izadd * f15 + this.zleft;
            n10 += n;
            n12 += n;
            if (bl) {
                f3 = this.xmult * ((float)n11 + 0.5f - (float)this.SCREEN_WIDTH / 2.0f);
                f4 = this.ymult * ((float)n3 + 0.5f - (float)this.SCREEN_HEIGHT / 2.0f);
                f6 = f3 * this.ax + f4 * this.ay + f5 * this.az;
                f7 = f3 * this.bx + f4 * this.by + f5 * this.bz;
                f8 = f3 * this.cx + f4 * this.cy + f5 * this.cz;
            }
            boolean bl2 = this.newcx > 0.0f != f8 > 0.0f;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            float f17 = 0.0f;
            float f18 = 0.0f;
            float f19 = 0.0f;
            float f20 = 0.0f;
            if (bl && bl2) {
                n9 = (n12 - n10 - 1) % n6;
                n8 = n6 - n9;
                float f21 = (float)n9 / (float)n6;
                float f22 = (float)n8 / (float)n6;
                n19 = n8;
                float f23 = f6 - f22 * this.newax;
                float f24 = f7 - f22 * this.newbx;
                float f25 = f8 - f22 * this.newcx;
                float f26 = 65536.0f / f25;
                f19 = f23 * f26;
                f20 = f24 * f26;
                f26 = 65536.0f / (f8 += f21 * this.newcx);
                f17 = (f6 += f21 * this.newax) * f26;
                f18 = (f7 += f21 * this.newbx) * f26;
                n20 = (int)(f17 - f19) >> n5;
                n21 = (int)(f18 - f20) >> n5;
                n13 = (int)f19 + (n8 - 1) * n20;
                n14 = (int)f20 + (n8 - 1) * n21;
            } else {
                float f27 = 65536.0f / f8;
                f17 = f6 * f27;
                f18 = f7 * f27;
            }
            while (n10 < n12) {
                if (bl) {
                    if (n19 == n6) {
                        n19 = 0;
                    }
                    if (n19 == 0) {
                        float f28 = 65536.0f / (f8 += this.newcx);
                        f19 = f17;
                        f20 = f18;
                        f17 = (f6 += this.newax) * f28;
                        f18 = (f7 += this.newbx) * f28;
                        n13 = (int)f19;
                        n14 = (int)f20;
                        n20 = (int)(f17 - f19) >> n5;
                        n21 = (int)(f18 - f20) >> n5;
                    } else {
                        n13 += n20;
                        n14 += n21;
                    }
                    ++n19;
                }
                try {
                    if (this.noDepthTest || f16 <= this.m_zbuffer[n10]) {
                        int n22;
                        int n23;
                        n9 = n18 >> 16;
                        if (this.m_bilinear) {
                            int n24 = (n14 >> 16) * this.TEX_WIDTH + (n13 >> 16);
                            int n25 = (n13 & 0xFFFF) >> 9;
                            int n26 = (n14 & 0xFFFF) >> 9;
                            int n27 = this.m_texture[n24];
                            int n28 = this.m_texture[n24 + 1];
                            if (n24 < n4) {
                                n24 += this.TEX_WIDTH;
                            }
                            int n29 = this.m_texture[n24];
                            int n30 = this.m_texture[n24 + 1];
                            int n31 = n27 & 0xFF0000;
                            int n32 = n29 & 0xFF0000;
                            int n33 = n31 + (((n28 & 0xFF0000) - n31) * n25 >> 7);
                            int n34 = n32 + (((n30 & 0xFF0000) - n32) * n25 >> 7);
                            n8 = n33 + ((n34 - n33) * n26 >> 7) >> 16;
                            n31 = n27 & 0xFF00;
                            n32 = n29 & 0xFF00;
                            n33 = n31 + (((n28 & 0xFF00) - n31) * n25 >> 7);
                            n34 = n32 + (((n30 & 0xFF00) - n32) * n25 >> 7);
                            n23 = n33 + ((n34 - n33) * n26 >> 7) >> 8;
                            n31 = n27 & 0xFF;
                            n32 = n29 & 0xFF;
                            n33 = n31 + (((n28 & 0xFF) - n31) * n25 >> 7);
                            n34 = n32 + (((n30 & 0xFF) - n32) * n25 >> 7);
                            n22 = n33 + ((n34 - n33) * n26 >> 7);
                        } else {
                            n22 = this.m_texture[(n14 >> 16) * this.TEX_WIDTH + (n13 >> 16)];
                            n8 = (n22 & 0xFF0000) >> 16;
                            n23 = (n22 & 0xFF00) >> 8;
                            n22 &= 0xFF;
                        }
                        n8 = n8 * n15 >>> 8;
                        n23 = n23 * n16 >>> 16;
                        n22 = n22 * n17 >>> 24;
                        int n35 = this.m_pixels[n10];
                        int n36 = n35 & 0xFF0000;
                        int n37 = n35 & 0xFF00;
                        this.m_pixels[n10] = 0xFF000000 | n36 + ((n8 - n36) * n9 >> 8) & 0xFF0000 | n37 + ((n23 - n37) * n9 >> 8) & 0xFF00 | (n35 &= 0xFF) + ((n22 - n35) * n9 >> 8) & 0xFF;
                        this.m_stencil[n10] = n7;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n11;
                if (!bl) {
                    n13 += this.iuadd;
                    n14 += this.ivadd;
                }
                n15 += this.iradd;
                n16 += this.igadd;
                n17 += this.ibadd;
                n18 += this.iaadd;
                f16 += this.izadd;
                ++n10;
            }
            ++n3;
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.aleft += this.aleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private void drawsegment_gouraud_texture32(float f, float f2, int n, int n2) {
        int n3 = n;
        int n4 = this.m_texture.length - this.TEX_WIDTH - 2;
        boolean bl = this.parent.hints[9];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n5 = TEX_INTERP_POWER;
        int n6 = 1 << n5;
        if (bl) {
            if (this.precomputeAccurateTexturing()) {
                this.newax *= (float)n6;
                this.newbx *= (float)n6;
                this.newcx *= (float)n6;
                f5 = this.nearPlaneDepth;
                this.firstSegment = false;
            } else {
                bl = false;
            }
        }
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        float f9 = this.iuadd;
        float f10 = this.ivadd;
        float f11 = this.iradd;
        float f12 = this.igadd;
        float f13 = this.ibadd;
        while (n < n2) {
            int n7;
            int n8;
            int n9 = (int)(this.xleft + 0.5f);
            if (n9 < 0) {
                n9 = 0;
            }
            int n10 = n9;
            int n11 = (int)(this.xrght + 0.5f);
            if (n11 > this.SCREEN_WIDTH) {
                n11 = this.SCREEN_WIDTH;
            }
            float f14 = (float)n9 + 0.5f - this.xleft;
            int n12 = (int)(f9 * f14 + this.uleft);
            int n13 = (int)(f10 * f14 + this.vleft);
            int n14 = (int)(f11 * f14 + this.rleft);
            int n15 = (int)(f12 * f14 + this.gleft);
            int n16 = (int)(f13 * f14 + this.bleft);
            float f15 = this.izadd * f14 + this.zleft;
            n9 += n;
            n11 += n;
            if (bl) {
                f3 = this.xmult * ((float)n10 + 0.5f - (float)this.SCREEN_WIDTH / 2.0f);
                f4 = this.ymult * ((float)n3 + 0.5f - (float)this.SCREEN_HEIGHT / 2.0f);
                f6 = f3 * this.ax + f4 * this.ay + f5 * this.az;
                f7 = f3 * this.bx + f4 * this.by + f5 * this.bz;
                f8 = f3 * this.cx + f4 * this.cy + f5 * this.cz;
            }
            boolean bl2 = this.newcx > 0.0f != f8 > 0.0f;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            float f16 = 0.0f;
            float f17 = 0.0f;
            float f18 = 0.0f;
            float f19 = 0.0f;
            if (bl && bl2) {
                n8 = (n11 - n9 - 1) % n6;
                n7 = n6 - n8;
                float f20 = (float)n8 / (float)n6;
                float f21 = (float)n7 / (float)n6;
                n17 = n7;
                float f22 = f6 - f21 * this.newax;
                float f23 = f7 - f21 * this.newbx;
                float f24 = f8 - f21 * this.newcx;
                float f25 = 65536.0f / f24;
                f18 = f22 * f25;
                f19 = f23 * f25;
                f25 = 65536.0f / (f8 += f20 * this.newcx);
                f16 = (f6 += f20 * this.newax) * f25;
                f17 = (f7 += f20 * this.newbx) * f25;
                n18 = (int)(f16 - f18) >> n5;
                n19 = (int)(f17 - f19) >> n5;
                n12 = (int)f18 + (n7 - 1) * n18;
                n13 = (int)f19 + (n7 - 1) * n19;
            } else {
                float f26 = 65536.0f / f8;
                f16 = f6 * f26;
                f17 = f7 * f26;
            }
            while (n9 < n11) {
                if (bl) {
                    if (n17 == n6) {
                        n17 = 0;
                    }
                    if (n17 == 0) {
                        float f27 = 65536.0f / (f8 += this.newcx);
                        f18 = f16;
                        f19 = f17;
                        f16 = (f6 += this.newax) * f27;
                        f17 = (f7 += this.newbx) * f27;
                        n12 = (int)f18;
                        n13 = (int)f19;
                        n18 = (int)(f16 - f18) >> n5;
                        n19 = (int)(f17 - f19) >> n5;
                    } else {
                        n12 += n18;
                        n13 += n19;
                    }
                    ++n17;
                }
                try {
                    if (this.noDepthTest || f15 <= this.m_zbuffer[n9]) {
                        int n20;
                        int n21;
                        if (this.m_bilinear) {
                            int n22 = (n13 >> 16) * this.TEX_WIDTH + (n12 >> 16);
                            int n23 = (n12 & 0xFFFF) >> 9;
                            int n24 = (n13 & 0xFFFF) >> 9;
                            int n25 = this.m_texture[n22];
                            int n26 = this.m_texture[n22 + 1];
                            if (n22 < n4) {
                                n22 += this.TEX_WIDTH;
                            }
                            int n27 = this.m_texture[n22];
                            int n28 = this.m_texture[n22 + 1];
                            int n29 = n25 & 0xFF0000;
                            int n30 = n27 & 0xFF0000;
                            int n31 = n29 + (((n26 & 0xFF0000) - n29) * n23 >> 7);
                            int n32 = n30 + (((n28 & 0xFF0000) - n30) * n23 >> 7);
                            n8 = n31 + ((n32 - n31) * n24 >> 7) >> 16;
                            n29 = n25 & 0xFF00;
                            n30 = n27 & 0xFF00;
                            n31 = n29 + (((n26 & 0xFF00) - n29) * n23 >> 7);
                            n32 = n30 + (((n28 & 0xFF00) - n30) * n23 >> 7);
                            n7 = n31 + ((n32 - n31) * n24 >> 7) >> 8;
                            n29 = n25 & 0xFF;
                            n30 = n27 & 0xFF;
                            n31 = n29 + (((n26 & 0xFF) - n29) * n23 >> 7);
                            n32 = n30 + (((n28 & 0xFF) - n30) * n23 >> 7);
                            n21 = n31 + ((n32 - n31) * n24 >> 7);
                            n31 = (n25 >>>= 24) + (((n26 >>> 24) - n25) * n23 >> 7);
                            n32 = (n27 >>>= 24) + (((n28 >>> 24) - n27) * n23 >> 7);
                            n20 = n31 + ((n32 - n31) * n24 >> 7);
                        } else {
                            n21 = this.m_texture[(n13 >> 16) * this.TEX_WIDTH + (n12 >> 16)];
                            n20 = n21 >>> 24;
                            n8 = (n21 & 0xFF0000) >> 16;
                            n7 = (n21 & 0xFF00) >> 8;
                            n21 &= 0xFF;
                        }
                        n8 = n8 * n14 >>> 8;
                        n7 = n7 * n15 >>> 16;
                        n21 = n21 * n16 >>> 24;
                        int n33 = this.m_pixels[n9];
                        int n34 = n33 & 0xFF0000;
                        int n35 = n33 & 0xFF00;
                        this.m_pixels[n9] = 0xFF000000 | n34 + ((n8 - n34) * n20 >> 8) & 0xFF0000 | n35 + ((n7 - n35) * n20 >> 8) & 0xFF00 | (n33 &= 0xFF) + ((n21 - n33) * n20 >> 8) & 0xFF;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n10;
                if (!bl) {
                    n12 += this.iuadd;
                    n13 += this.ivadd;
                }
                n14 += this.iradd;
                n15 += this.igadd;
                n16 += this.ibadd;
                f15 += this.izadd;
                ++n9;
            }
            ++n3;
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.zleft += this.zleftadd;
        }
    }

    private void drawsegment_gouraud_texture32_alpha(float f, float f2, int n, int n2) {
        int n3 = n;
        int n4 = this.m_texture.length - this.TEX_WIDTH - 2;
        boolean bl = this.parent.hints[9];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n5 = TEX_INTERP_POWER;
        int n6 = 1 << n5;
        if (bl) {
            if (this.precomputeAccurateTexturing()) {
                this.newax *= (float)n6;
                this.newbx *= (float)n6;
                this.newcx *= (float)n6;
                f5 = this.nearPlaneDepth;
                this.firstSegment = false;
            } else {
                bl = false;
            }
        }
        n *= this.SCREEN_WIDTH;
        n2 *= this.SCREEN_WIDTH;
        int n7 = this.m_index;
        float f9 = this.iuadd;
        float f10 = this.ivadd;
        float f11 = this.iradd;
        float f12 = this.igadd;
        float f13 = this.ibadd;
        float f14 = this.iaadd;
        while (n < n2) {
            int n8;
            int n9;
            int n10 = (int)(this.xleft + 0.5f);
            if (n10 < 0) {
                n10 = 0;
            }
            int n11 = n10;
            int n12 = (int)(this.xrght + 0.5f);
            if (n12 > this.SCREEN_WIDTH) {
                n12 = this.SCREEN_WIDTH;
            }
            float f15 = (float)n10 + 0.5f - this.xleft;
            int n13 = (int)(f9 * f15 + this.uleft);
            int n14 = (int)(f10 * f15 + this.vleft);
            int n15 = (int)(f11 * f15 + this.rleft);
            int n16 = (int)(f12 * f15 + this.gleft);
            int n17 = (int)(f13 * f15 + this.bleft);
            int n18 = (int)(f14 * f15 + this.aleft);
            float f16 = this.izadd * f15 + this.zleft;
            n10 += n;
            n12 += n;
            if (bl) {
                f3 = this.xmult * ((float)n11 + 0.5f - (float)this.SCREEN_WIDTH / 2.0f);
                f4 = this.ymult * ((float)n3 + 0.5f - (float)this.SCREEN_HEIGHT / 2.0f);
                f6 = f3 * this.ax + f4 * this.ay + f5 * this.az;
                f7 = f3 * this.bx + f4 * this.by + f5 * this.bz;
                f8 = f3 * this.cx + f4 * this.cy + f5 * this.cz;
            }
            boolean bl2 = this.newcx > 0.0f != f8 > 0.0f;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            float f17 = 0.0f;
            float f18 = 0.0f;
            float f19 = 0.0f;
            float f20 = 0.0f;
            if (bl && bl2) {
                n9 = (n12 - n10 - 1) % n6;
                n8 = n6 - n9;
                float f21 = (float)n9 / (float)n6;
                float f22 = (float)n8 / (float)n6;
                n19 = n8;
                float f23 = f6 - f22 * this.newax;
                float f24 = f7 - f22 * this.newbx;
                float f25 = f8 - f22 * this.newcx;
                float f26 = 65536.0f / f25;
                f19 = f23 * f26;
                f20 = f24 * f26;
                f26 = 65536.0f / (f8 += f21 * this.newcx);
                f17 = (f6 += f21 * this.newax) * f26;
                f18 = (f7 += f21 * this.newbx) * f26;
                n20 = (int)(f17 - f19) >> n5;
                n21 = (int)(f18 - f20) >> n5;
                n13 = (int)f19 + (n8 - 1) * n20;
                n14 = (int)f20 + (n8 - 1) * n21;
            } else {
                float f27 = 65536.0f / f8;
                f17 = f6 * f27;
                f18 = f7 * f27;
            }
            while (n10 < n12) {
                if (bl) {
                    if (n19 == n6) {
                        n19 = 0;
                    }
                    if (n19 == 0) {
                        float f28 = 65536.0f / (f8 += this.newcx);
                        f19 = f17;
                        f20 = f18;
                        f17 = (f6 += this.newax) * f28;
                        f18 = (f7 += this.newbx) * f28;
                        n13 = (int)f19;
                        n14 = (int)f20;
                        n20 = (int)(f17 - f19) >> n5;
                        n21 = (int)(f18 - f20) >> n5;
                    } else {
                        n13 += n20;
                        n14 += n21;
                    }
                    ++n19;
                }
                try {
                    if (this.noDepthTest || f16 <= this.m_zbuffer[n10]) {
                        int n22;
                        int n23;
                        n9 = n18 >> 16;
                        if (this.m_bilinear) {
                            int n24 = (n14 >> 16) * this.TEX_WIDTH + (n13 >> 16);
                            int n25 = (n13 & 0xFFFF) >> 9;
                            int n26 = (n14 & 0xFFFF) >> 9;
                            int n27 = this.m_texture[n24];
                            int n28 = this.m_texture[n24 + 1];
                            if (n24 < n4) {
                                n24 += this.TEX_WIDTH;
                            }
                            int n29 = this.m_texture[n24];
                            int n30 = this.m_texture[n24 + 1];
                            int n31 = n27 & 0xFF0000;
                            int n32 = n29 & 0xFF0000;
                            int n33 = n31 + (((n28 & 0xFF0000) - n31) * n25 >> 7);
                            int n34 = n32 + (((n30 & 0xFF0000) - n32) * n25 >> 7);
                            n8 = n33 + ((n34 - n33) * n26 >> 7) >> 16;
                            n31 = n27 & 0xFF00;
                            n32 = n29 & 0xFF00;
                            n33 = n31 + (((n28 & 0xFF00) - n31) * n25 >> 7);
                            n34 = n32 + (((n30 & 0xFF00) - n32) * n25 >> 7);
                            n23 = n33 + ((n34 - n33) * n26 >> 7) >> 8;
                            n31 = n27 & 0xFF;
                            n32 = n29 & 0xFF;
                            n33 = n31 + (((n28 & 0xFF) - n31) * n25 >> 7);
                            n34 = n32 + (((n30 & 0xFF) - n32) * n25 >> 7);
                            n22 = n33 + ((n34 - n33) * n26 >> 7);
                            n33 = (n27 >>>= 24) + (((n28 >>> 24) - n27) * n25 >> 7);
                            n34 = (n29 >>>= 24) + (((n30 >>> 24) - n29) * n25 >> 7);
                            n9 = n9 * (n33 + ((n34 - n33) * n26 >> 7)) >> 8;
                        } else {
                            n22 = this.m_texture[(n14 >> 16) * this.TEX_WIDTH + (n13 >> 16)];
                            n9 = n9 * (n22 >>> 24) >> 8;
                            n8 = (n22 & 0xFF0000) >> 16;
                            n23 = (n22 & 0xFF00) >> 8;
                            n22 &= 0xFF;
                        }
                        n8 = n8 * n15 >>> 8;
                        n23 = n23 * n16 >>> 16;
                        n22 = n22 * n17 >>> 24;
                        int n35 = this.m_pixels[n10];
                        int n36 = n35 & 0xFF0000;
                        int n37 = n35 & 0xFF00;
                        this.m_pixels[n10] = 0xFF000000 | n36 + ((n8 - n36) * n9 >> 8) & 0xFF0000 | n37 + ((n23 - n37) * n9 >> 8) & 0xFF00 | (n35 &= 0xFF) + ((n22 - n35) * n9 >> 8) & 0xFF;
                        this.m_stencil[n10] = n7;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n11;
                if (!bl) {
                    n13 += this.iuadd;
                    n14 += this.ivadd;
                }
                n15 += this.iradd;
                n16 += this.igadd;
                n17 += this.ibadd;
                n18 += this.iaadd;
                f16 += this.izadd;
                ++n10;
            }
            ++n3;
            n += this.SCREEN_WIDTH;
            this.xleft += f;
            this.xrght += f2;
            this.uleft += this.uleftadd;
            this.vleft += this.vleftadd;
            this.rleft += this.rleftadd;
            this.gleft += this.gleftadd;
            this.bleft += this.bleftadd;
            this.aleft += this.aleftadd;
            this.zleft += this.zleftadd;
        }
    }
}

