/*
 * Decompiled with CFR 0.152.
 */
package megamu.shapetween;

import megamu.shapetween.ShapeTweenConstants;

public abstract class Shaper
implements ShapeTweenConstants {
    public int shapeMode = 2;
    public float transitionX = 0.5f;
    public float transitionY = 0.5f;
    public boolean clamp = false;

    public float shape(float in) {
        return this.shape(in, this.clamp);
    }

    protected float shape(float in, boolean forceClamp) {
        float out;
        switch (this.shapeMode) {
            default: {
                out = this.f(in);
                break;
            }
            case 1: {
                out = this.invf(in);
                break;
            }
            case 2: {
                if (in < this.transitionX) {
                    out = this.f(in / this.transitionX) * this.transitionY;
                    break;
                }
                out = this.invf((in - this.transitionX) / (1.0f - this.transitionX)) * (1.0f - this.transitionY) + this.transitionY;
                break;
            }
            case 3: {
                out = in < this.transitionX ? this.invf(in / this.transitionX) * this.transitionY : this.f((in - this.transitionX) / (1.0f - this.transitionX)) * (1.0f - this.transitionY) + this.transitionY;
            }
        }
        if (forceClamp) {
            out = Math.max(Math.min(out, 1.0f), 0.0f);
        }
        return out;
    }

    public float slope(float in) {
        float shaped;
        if (this.clamp && ((shaped = this.shape(in, false)) < 0.0f || shaped > 1.0f)) {
            return 0.0f;
        }
        switch (this.shapeMode) {
            default: {
                return this.df(in);
            }
            case 1: {
                return this.invdf(in);
            }
            case 2: {
                if (in < this.transitionX) {
                    return this.df(in / this.transitionX);
                }
                return this.invdf((in - this.transitionX) / (1.0f - this.transitionX));
            }
            case 3: 
        }
        if (in < this.transitionX) {
            return this.invdf(in / this.transitionX);
        }
        return this.df((in - this.transitionX) / (1.0f - this.transitionX));
    }

    public float secondSlope(float in) {
        float shaped;
        if (this.clamp && ((shaped = this.shape(in, false)) < 0.0f || shaped > 1.0f)) {
            return 0.0f;
        }
        switch (this.shapeMode) {
            default: {
                return this.ddf(in);
            }
            case 1: {
                return this.invddf(in);
            }
            case 2: {
                if (in < this.transitionX) {
                    return this.ddf(in / this.transitionX) / this.transitionX;
                }
                return this.invddf((in - this.transitionX) / (1.0f - this.transitionX)) / (1.0f - this.transitionX);
            }
            case 3: 
        }
        if (in < this.transitionX) {
            return this.invddf(in / this.transitionX) / this.transitionX;
        }
        return this.ddf((in - this.transitionX) / (1.0f - this.transitionX)) / (1.0f - this.transitionX);
    }

    public static float shape(Class shape, float in) {
        if (shape == null) {
            return in;
        }
        try {
            Object[] args = new Object[]{new Float(in)};
            return ((Float)shape.getMethod("shape", ShapeTweenConstants.ARGS).invoke(shape.newInstance(), args)).floatValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public void setMode(int mode) {
        this.shapeMode = mode;
    }

    public void easeIn() {
        this.setMode(0);
    }

    public void easeOut() {
        this.setMode(1);
    }

    public void easeInOut() {
        this.setMode(2);
    }

    public void setTransitionPoint(float x, float y) {
        this.transitionX = Math.min(Math.max(x, 0.0f), 1.0f);
        this.transitionY = Math.min(Math.max(y, 0.0f), 1.0f);
    }

    public void setTransitionPoint(float x) {
        this.setTransitionPoint(x, x);
    }

    public void clamp() {
        this.clamp = true;
    }

    public void noClamp() {
        this.clamp = false;
    }

    protected abstract float f(float var1);

    protected abstract float df(float var1);

    protected abstract float ddf(float var1);

    protected float invf(float x) {
        return 1.0f - this.f(1.0f - x);
    }

    protected float invdf(float x) {
        return this.df(1.0f - x);
    }

    protected float invddf(float x) {
        return -this.ddf(1.0f - x);
    }
}

