/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import processing.core.PConstants;
import processing.core.PGraphics3D;
import processing.core.PImage;
import processing.core.PMatrix3D;

public class PSmoothTriangle
implements PConstants {
    private static final boolean EWJORDAN = false;
    private static final boolean FRY = false;
    static final int X = 0;
    static final int Y = 1;
    static final int Z = 2;
    static final int R = 3;
    static final int G = 4;
    static final int B = 5;
    static final int A = 6;
    static final int U = 7;
    static final int V = 8;
    static final int DEFAULT_SIZE = 64;
    float[][] vertices = new float[64][36];
    int vertexCount;
    static final int ZBUFFER_MIN_COVERAGE = 204;
    float[] r = new float[64];
    float[] dr = new float[64];
    float[] l = new float[64];
    float[] dl = new float[64];
    float[] sp = new float[64];
    float[] sdp = new float[64];
    boolean interpX;
    boolean interpZ;
    boolean interpUV;
    boolean interpARGB;
    int rgba;
    int r2;
    int g2;
    int b2;
    int a2;
    int a2orig;
    boolean noDepthTest;
    PGraphics3D parent;
    int[] pixels;
    float[] zbuffer;
    int width;
    int height;
    int width1;
    int height1;
    PImage timage;
    int[] tpixels;
    int theight;
    int twidth;
    int theight1;
    int twidth1;
    int tformat;
    boolean texture_smooth;
    static final int SUBXRES = 8;
    static final int SUBXRES1 = 7;
    static final int SUBYRES = 8;
    static final int SUBYRES1 = 7;
    static final int MAX_COVERAGE = 64;
    boolean smooth;
    int firstModY;
    int lastModY;
    int lastY;
    int[] aaleft = new int[8];
    int[] aaright = new int[8];
    int aaleftmin;
    int aarightmin;
    int aaleftmax;
    int aarightmax;
    int aaleftfull;
    int aarightfull;
    private float[] camX = new float[3];
    private float[] camY = new float[3];
    private float[] camZ = new float[3];
    private float ax;
    private float ay;
    private float az;
    private float bx;
    private float by;
    private float bz;
    private float cx;
    private float cy;
    private float cz;
    private float nearPlaneWidth;
    private float nearPlaneHeight;
    private float nearPlaneDepth;
    private float xmult;
    private float ymult;

    private final int MODYRES(int y) {
        return y & 7;
    }

    public PSmoothTriangle(PGraphics3D iparent) {
        this.parent = iparent;
        this.reset(0);
    }

    public void reset(int count) {
        this.vertexCount = count;
        this.interpX = true;
        this.interpZ = true;
        this.interpUV = false;
        this.interpARGB = true;
        this.timage = null;
    }

    public float[] nextVertex() {
        if (this.vertexCount == this.vertices.length) {
            float[][] temp = new float[this.vertexCount << 1][36];
            System.arraycopy(this.vertices, 0, temp, 0, this.vertexCount);
            this.vertices = temp;
            this.r = new float[this.vertices.length];
            this.dr = new float[this.vertices.length];
            this.l = new float[this.vertices.length];
            this.dl = new float[this.vertices.length];
            this.sp = new float[this.vertices.length];
            this.sdp = new float[this.vertices.length];
        }
        return this.vertices[this.vertexCount++];
    }

    public void texture(PImage image) {
        this.timage = image;
        this.tpixels = image.pixels;
        this.twidth = image.width;
        this.theight = image.height;
        this.tformat = image.format;
        this.twidth1 = this.twidth - 1;
        this.theight1 = this.theight - 1;
        this.interpUV = true;
    }

    /*
     * Unable to fully structure code
     */
    public void render() {
        if (this.vertexCount < 3) {
            return;
        }
        this.smooth = true;
        this.pixels = this.parent.pixels;
        this.zbuffer = this.parent.zbuffer;
        this.noDepthTest = false;
        this.texture_smooth = true;
        this.width = this.smooth != false ? this.parent.width * 8 : this.parent.width;
        this.height = this.smooth != false ? this.parent.height * 8 : this.parent.height;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        if (!this.interpARGB) {
            this.r2 = (int)(this.vertices[0][3] * 255.0f);
            this.g2 = (int)(this.vertices[0][4] * 255.0f);
            this.b2 = (int)(this.vertices[0][5] * 255.0f);
            this.a2orig = this.a2 = (int)(this.vertices[0][6] * 255.0f);
            this.rgba = -16777216 | this.r2 << 16 | this.g2 << 8 | this.b2;
        }
        i = 0;
        while (i < this.vertexCount) {
            this.r[i] = 0.0f;
            this.dr[i] = 0.0f;
            this.l[i] = 0.0f;
            this.dl[i] = 0.0f;
            ++i;
        }
        if (this.smooth) {
            i = 0;
            while (i < this.vertexCount) {
                v0 = this.vertices[i];
                v0[0] = v0[0] * 8.0f;
                v1 = this.vertices[i];
                v1[1] = v1[1] * 8.0f;
                ++i;
            }
            this.firstModY = -1;
        }
        topi = 0;
        ymin = this.vertices[0][1];
        ymax = this.vertices[0][1];
        i = 1;
        while (i < this.vertexCount) {
            if (this.vertices[i][1] < ymin) {
                ymin = this.vertices[i][1];
                topi = i;
            }
            if (this.vertices[i][1] > ymax) {
                ymax = this.vertices[i][1];
            }
            ++i;
        }
        this.lastY = (int)(ymax - 0.5f);
        lefti = topi;
        righti = topi;
        y = (int)(ymin + 0.5f);
        lefty = y - 1;
        righty = y - 1;
        this.interpX = true;
        remaining = this.vertexCount;
        ** GOTO lbl81
        {
            --remaining;
            i = lefti != 0 ? lefti - 1 : this.vertexCount - 1;
            this.incrementalize_y(this.vertices[lefti], this.vertices[i], this.l, this.dl, y);
            lefty = (int)(this.vertices[i][1] + 0.5f);
            lefti = i;
            do {
                if (lefty <= y && remaining > 0) continue block3;
                while (righty <= y && remaining > 0) {
                    --remaining;
                    i = righti != this.vertexCount - 1 ? righti + 1 : 0;
                    this.incrementalize_y(this.vertices[righti], this.vertices[i], this.r, this.dr, y);
                    righty = (int)(this.vertices[i][1] + 0.5f);
                    righti = i;
                }
                while (y < lefty && y < righty) {
                    if (y >= 0 && y < this.height) {
                        if (this.l[0] <= this.r[0]) {
                            this.scanline(y, this.l, this.r);
                        } else {
                            this.scanline(y, this.r, this.l);
                        }
                    }
                    ++y;
                    this.increment(this.l, this.dl);
                    this.increment(this.r, this.dr);
                }
lbl81:
                // 2 sources

            } while (remaining > 0);
        }
    }

    public void unexpand() {
        if (this.smooth) {
            int i = 0;
            while (i < this.vertexCount) {
                float[] fArray = this.vertices[i];
                fArray[0] = fArray[0] / 8.0f;
                float[] fArray2 = this.vertices[i];
                fArray2[1] = fArray2[1] / 8.0f;
                ++i;
            }
        }
    }

    private void scanline(int y, float[] l, float[] r) {
        int rx;
        int i = 0;
        while (i < this.vertexCount) {
            this.sp[i] = 0.0f;
            this.sdp[i] = 0.0f;
            ++i;
        }
        int lx = (int)(l[0] + 0.49999f);
        if (lx < 0) {
            lx = 0;
        }
        if ((rx = (int)(r[0] - 0.5f)) > this.width1) {
            rx = this.width1;
        }
        if (lx > rx) {
            return;
        }
        if (this.smooth) {
            int mody = this.MODYRES(y);
            this.aaleft[mody] = lx;
            this.aaright[mody] = rx;
            if (this.firstModY == -1) {
                this.firstModY = mody;
                this.aaleftmin = lx;
                this.aaleftmax = lx;
                this.aarightmin = rx;
                this.aarightmax = rx;
            } else {
                if (this.aaleftmin > this.aaleft[mody]) {
                    this.aaleftmin = this.aaleft[mody];
                }
                if (this.aaleftmax < this.aaleft[mody]) {
                    this.aaleftmax = this.aaleft[mody];
                }
                if (this.aarightmin > this.aaright[mody]) {
                    this.aarightmin = this.aaright[mody];
                }
                if (this.aarightmax < this.aaright[mody]) {
                    this.aarightmax = this.aaright[mody];
                }
            }
            this.lastModY = mody;
            if (mody != 7 && y != this.lastY) {
                return;
            }
            this.aaleftfull = this.aaleftmax / 8 + 1;
            this.aarightfull = this.aarightmin / 8 - 1;
        }
        this.incrementalize_x(l, r, this.sp, this.sdp, lx);
        int offset = this.smooth ? this.parent.width * (y / 8) : this.parent.width * y;
        int truelx = 0;
        int truerx = 0;
        if (this.smooth) {
            truelx = lx / 8;
            truerx = (rx + 7) / 8;
            lx = this.aaleftmin / 8;
            rx = (this.aarightmax + 7) / 8;
            if (lx < 0) {
                lx = 0;
            }
            if (rx > this.parent.width1) {
                rx = this.parent.width1;
            }
        }
        this.interpX = false;
        int x = lx;
        while (x <= rx) {
            if (this.noDepthTest || this.sp[2] <= this.zbuffer[offset + x]) {
                int a1;
                if (this.interpUV) {
                    int tb;
                    int tg;
                    int tr;
                    int ta;
                    int tu = (int)this.sp[7];
                    int tv = (int)this.sp[8];
                    if (tu > this.twidth1) {
                        tu = this.twidth1;
                    }
                    if (tv > this.theight1) {
                        tv = this.theight1;
                    }
                    if (tu < 0) {
                        tu = 0;
                    }
                    if (tv < 0) {
                        tv = 0;
                    }
                    int txy = tv * this.twidth + tu;
                    float[] uv = new float[2];
                    txy = this.getTextureIndex(x, (float)y * 1.0f / 8.0f, uv);
                    tu = (int)uv[0];
                    tv = (int)uv[1];
                    txy = this.twidth * tv + tu;
                    if (this.smooth || this.texture_smooth) {
                        int weight;
                        int p11;
                        int p10;
                        int p01;
                        int p00;
                        int px1;
                        int px0;
                        int pixel11;
                        int tuf1 = (int)(255.0f * (uv[0] - (float)tu));
                        int tvf1 = (int)(255.0f * (uv[1] - (float)tv));
                        int tuf = 255 - tuf1;
                        int tvf = 255 - tvf1;
                        int pixel00 = this.tpixels[txy];
                        int pixel01 = tv < this.theight1 ? this.tpixels[txy + this.twidth] : this.tpixels[txy];
                        int pixel10 = tu < this.twidth1 ? this.tpixels[txy + 1] : this.tpixels[txy];
                        int n = pixel11 = tv < this.theight1 && tu < this.twidth1 ? this.tpixels[txy + this.twidth + 1] : this.tpixels[txy];
                        if (this.tformat == 4) {
                            px0 = pixel00 * tuf + pixel10 * tuf1 >> 8;
                            px1 = pixel01 * tuf + pixel11 * tuf1 >> 8;
                            ta = (px0 * tvf + px1 * tvf1 >> 8) * (this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig) >> 8;
                        } else if (this.tformat == 2) {
                            p00 = pixel00 >> 24 & 0xFF;
                            p01 = pixel01 >> 24 & 0xFF;
                            p10 = pixel10 >> 24 & 0xFF;
                            p11 = pixel11 >> 24 & 0xFF;
                            px0 = p00 * tuf + p10 * tuf1 >> 8;
                            px1 = p01 * tuf + p11 * tuf1 >> 8;
                            ta = (px0 * tvf + px1 * tvf1 >> 8) * (this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig) >> 8;
                        } else {
                            int n2 = ta = this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig;
                        }
                        if (this.tformat == 1 || this.tformat == 2) {
                            p00 = pixel00 >> 16 & 0xFF;
                            p01 = pixel01 >> 16 & 0xFF;
                            p10 = pixel10 >> 16 & 0xFF;
                            p11 = pixel11 >> 16 & 0xFF;
                            px0 = p00 * tuf + p10 * tuf1 >> 8;
                            px1 = p01 * tuf + p11 * tuf1 >> 8;
                            tr = (px0 * tvf + px1 * tvf1 >> 8) * (this.interpARGB ? (int)(this.sp[3] * 255.0f) : this.r2) >> 8;
                            p00 = pixel00 >> 8 & 0xFF;
                            p01 = pixel01 >> 8 & 0xFF;
                            p10 = pixel10 >> 8 & 0xFF;
                            p11 = pixel11 >> 8 & 0xFF;
                            px0 = p00 * tuf + p10 * tuf1 >> 8;
                            px1 = p01 * tuf + p11 * tuf1 >> 8;
                            tg = (px0 * tvf + px1 * tvf1 >> 8) * (this.interpARGB ? (int)(this.sp[4] * 255.0f) : this.g2) >> 8;
                            p00 = pixel00 & 0xFF;
                            p01 = pixel01 & 0xFF;
                            p10 = pixel10 & 0xFF;
                            p11 = pixel11 & 0xFF;
                            px0 = p00 * tuf + p10 * tuf1 >> 8;
                            px1 = p01 * tuf + p11 * tuf1 >> 8;
                            tb = (px0 * tvf + px1 * tvf1 >> 8) * (this.interpARGB ? (int)(this.sp[5] * 255.0f) : this.b2) >> 8;
                        } else if (this.interpARGB) {
                            tr = (int)(this.sp[3] * 255.0f);
                            tg = (int)(this.sp[4] * 255.0f);
                            tb = (int)(this.sp[5] * 255.0f);
                        } else {
                            tr = this.r2;
                            tg = this.g2;
                            tb = this.b2;
                        }
                        int n3 = weight = this.smooth ? this.coverage(x) : 255;
                        if (weight != 255) {
                            ta = ta * weight >> 8;
                        }
                    } else {
                        int tpixel = this.tpixels[txy];
                        if (this.tformat == 4) {
                            ta = tpixel;
                            if (this.interpARGB) {
                                tr = (int)(this.sp[3] * 255.0f);
                                tg = (int)(this.sp[4] * 255.0f);
                                tb = (int)(this.sp[5] * 255.0f);
                                if (this.sp[6] != 1.0f) {
                                    ta = (int)(this.sp[6] * 255.0f) * ta >> 8;
                                }
                            } else {
                                tr = this.r2;
                                tg = this.g2;
                                tb = this.b2;
                                ta = this.a2orig * ta >> 8;
                            }
                        } else {
                            int n = ta = this.tformat == 1 ? 255 : tpixel >> 24 & 0xFF;
                            if (this.interpARGB) {
                                tr = (int)(this.sp[3] * 255.0f) * (tpixel >> 16 & 0xFF) >> 8;
                                tg = (int)(this.sp[4] * 255.0f) * (tpixel >> 8 & 0xFF) >> 8;
                                tb = (int)(this.sp[5] * 255.0f) * (tpixel & 0xFF) >> 8;
                                ta = (int)(this.sp[6] * 255.0f) * ta >> 8;
                            } else {
                                tr = this.r2 * (tpixel >> 16 & 0xFF) >> 8;
                                tg = this.g2 * (tpixel >> 8 & 0xFF) >> 8;
                                tb = this.b2 * (tpixel & 0xFF) >> 8;
                                ta = this.a2orig * ta >> 8;
                            }
                        }
                    }
                    if (ta == 254 || ta == 255) {
                        this.pixels[offset + x] = 0xFF000000 | tr << 16 | tg << 8 | tb;
                        this.zbuffer[offset + x] = this.sp[2];
                    } else {
                        a1 = 255 - ta;
                        int r1 = this.pixels[offset + x] >> 16 & 0xFF;
                        int g1 = this.pixels[offset + x] >> 8 & 0xFF;
                        int b1 = this.pixels[offset + x] & 0xFF;
                        this.pixels[offset + x] = 0xFF000000 | tr * ta + r1 * a1 >> 8 << 16 | tg * ta + g1 * a1 & 0xFF00 | tb * ta + b1 * a1 >> 8;
                        if (ta > 204) {
                            this.zbuffer[offset + x] = this.sp[2];
                        }
                    }
                } else {
                    int weight;
                    int n = weight = this.smooth ? this.coverage(x) : 255;
                    if (this.interpARGB) {
                        this.r2 = (int)(this.sp[3] * 255.0f);
                        this.g2 = (int)(this.sp[4] * 255.0f);
                        this.b2 = (int)(this.sp[5] * 255.0f);
                        if (this.sp[6] != 1.0f) {
                            weight = weight * (int)(this.sp[6] * 255.0f) >> 8;
                        }
                        if (weight == 255) {
                            this.rgba = 0xFF000000 | this.r2 << 16 | this.g2 << 8 | this.b2;
                        }
                    } else if (this.a2orig != 255) {
                        weight = weight * this.a2orig >> 8;
                    }
                    if (weight == 255) {
                        this.pixels[offset + x] = this.rgba;
                        this.zbuffer[offset + x] = this.sp[2];
                    } else {
                        int r1 = this.pixels[offset + x] >> 16 & 0xFF;
                        int g1 = this.pixels[offset + x] >> 8 & 0xFF;
                        int b1 = this.pixels[offset + x] & 0xFF;
                        this.a2 = weight;
                        a1 = 255 - this.a2;
                        this.pixels[offset + x] = 0xFF000000 | r1 * a1 + this.r2 * this.a2 >> 8 << 16 | g1 * a1 + this.g2 * this.a2 >> 8 << 8 | b1 * a1 + this.b2 * this.a2 >> 8;
                        if (this.a2 > 204) {
                            this.zbuffer[offset + x] = this.sp[2];
                        }
                    }
                }
            }
            if (!this.smooth || x >= truelx && x <= truerx) {
                this.increment(this.sp, this.sdp);
            }
            ++x;
        }
        this.firstModY = -1;
        this.interpX = true;
    }

    private int coverage(int x) {
        if (x >= this.aaleftfull && x <= this.aarightfull && this.firstModY == 0 && this.lastModY == 7) {
            return 255;
        }
        int pixelLeft = x * 8;
        int pixelRight = pixelLeft + 8;
        int amt = 0;
        int i = this.firstModY;
        while (i <= this.lastModY) {
            if (this.aaleft[i] <= pixelRight && this.aaright[i] >= pixelLeft) {
                amt += (this.aaright[i] < pixelRight ? this.aaright[i] : pixelRight) - (this.aaleft[i] > pixelLeft ? this.aaleft[i] : pixelLeft);
            }
            ++i;
        }
        return (amt <<= 2) == 256 ? 255 : amt;
    }

    private void incrementalize_y(float[] p1, float[] p2, float[] p, float[] dp, int y) {
        float delta = p2[1] - p1[1];
        if (delta == 0.0f) {
            delta = 1.0f;
        }
        float fraction = (float)y + 0.5f - p1[1];
        if (this.interpX) {
            dp[0] = (p2[0] - p1[0]) / delta;
            p[0] = p1[0] + dp[0] * fraction;
        }
        if (this.interpZ) {
            dp[2] = (p2[2] - p1[2]) / delta;
            p[2] = p1[2] + dp[2] * fraction;
        }
        if (this.interpARGB) {
            dp[3] = (p2[3] - p1[3]) / delta;
            dp[4] = (p2[4] - p1[4]) / delta;
            dp[5] = (p2[5] - p1[5]) / delta;
            dp[6] = (p2[6] - p1[6]) / delta;
            p[3] = p1[3] + dp[3] * fraction;
            p[4] = p1[4] + dp[4] * fraction;
            p[5] = p1[5] + dp[5] * fraction;
            p[6] = p1[6] + dp[6] * fraction;
        }
        if (this.interpUV) {
            dp[7] = (p2[7] - p1[7]) / delta;
            dp[8] = (p2[8] - p1[8]) / delta;
            p[7] = p1[7] + dp[7] * fraction;
            p[8] = p1[8] + dp[8] * fraction;
        }
    }

    private void incrementalize_x(float[] p1, float[] p2, float[] p, float[] dp, int x) {
        float delta = p2[0] - p1[0];
        if (delta == 0.0f) {
            delta = 1.0f;
        }
        float fraction = (float)x + 0.5f - p1[0];
        if (this.smooth) {
            delta /= 8.0f;
            fraction /= 8.0f;
        }
        if (this.interpX) {
            dp[0] = (p2[0] - p1[0]) / delta;
            p[0] = p1[0] + dp[0] * fraction;
        }
        if (this.interpZ) {
            dp[2] = (p2[2] - p1[2]) / delta;
            p[2] = p1[2] + dp[2] * fraction;
        }
        if (this.interpARGB) {
            dp[3] = (p2[3] - p1[3]) / delta;
            dp[4] = (p2[4] - p1[4]) / delta;
            dp[5] = (p2[5] - p1[5]) / delta;
            dp[6] = (p2[6] - p1[6]) / delta;
            p[3] = p1[3] + dp[3] * fraction;
            p[4] = p1[4] + dp[4] * fraction;
            p[5] = p1[5] + dp[5] * fraction;
            p[6] = p1[6] + dp[6] * fraction;
        }
        if (this.interpUV) {
            dp[7] = (p2[7] - p1[7]) / delta;
            dp[8] = (p2[8] - p1[8]) / delta;
            p[7] = p1[7] + dp[7] * fraction;
            p[8] = p1[8] + dp[8] * fraction;
        }
    }

    private void increment(float[] p, float[] dp) {
        if (this.interpX) {
            p[0] = p[0] + dp[0];
        }
        if (this.interpZ) {
            p[2] = p[2] + dp[2];
        }
        if (this.interpARGB) {
            p[3] = p[3] + dp[3];
            p[4] = p[4] + dp[4];
            p[5] = p[5] + dp[5];
            p[6] = p[6] + dp[6];
        }
        if (this.interpUV) {
            p[7] = p[7] + dp[7];
            p[8] = p[8] + dp[8];
        }
    }

    public void setCamVertices(float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2) {
        this.camX[0] = x0;
        this.camX[1] = x1;
        this.camX[2] = x2;
        this.camY[0] = y0;
        this.camY[1] = y1;
        this.camY[2] = y2;
        this.camZ[0] = z0;
        this.camZ[1] = z1;
        this.camZ[2] = z2;
    }

    public void setVertices(float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2) {
        this.vertices[0][0] = x0;
        this.vertices[1][0] = x1;
        this.vertices[2][0] = x2;
        this.vertices[0][1] = y0;
        this.vertices[1][1] = y1;
        this.vertices[2][1] = y2;
        this.vertices[0][2] = z0;
        this.vertices[1][2] = z1;
        this.vertices[2][2] = z2;
    }

    boolean precomputeAccurateTexturing() {
        int o0 = 0;
        int o1 = 1;
        int o2 = 2;
        PMatrix3D myMatrix = new PMatrix3D(this.vertices[o0][7], this.vertices[o0][8], 1.0f, 0.0f, this.vertices[o1][7], this.vertices[o1][8], 1.0f, 0.0f, this.vertices[o2][7], this.vertices[o2][8], 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        boolean invertSuccess = myMatrix.invert();
        if (!invertSuccess) {
            return false;
        }
        float m00 = myMatrix.m00 * this.camX[o0] + myMatrix.m01 * this.camX[o1] + myMatrix.m02 * this.camX[o2];
        float m01 = myMatrix.m10 * this.camX[o0] + myMatrix.m11 * this.camX[o1] + myMatrix.m12 * this.camX[o2];
        float m02 = myMatrix.m20 * this.camX[o0] + myMatrix.m21 * this.camX[o1] + myMatrix.m22 * this.camX[o2];
        float m10 = myMatrix.m00 * this.camY[o0] + myMatrix.m01 * this.camY[o1] + myMatrix.m02 * this.camY[o2];
        float m11 = myMatrix.m10 * this.camY[o0] + myMatrix.m11 * this.camY[o1] + myMatrix.m12 * this.camY[o2];
        float m12 = myMatrix.m20 * this.camY[o0] + myMatrix.m21 * this.camY[o1] + myMatrix.m22 * this.camY[o2];
        float m20 = -(myMatrix.m00 * this.camZ[o0] + myMatrix.m01 * this.camZ[o1] + myMatrix.m02 * this.camZ[o2]);
        float m21 = -(myMatrix.m10 * this.camZ[o0] + myMatrix.m11 * this.camZ[o1] + myMatrix.m12 * this.camZ[o2]);
        float m22 = -(myMatrix.m20 * this.camZ[o0] + myMatrix.m21 * this.camZ[o1] + myMatrix.m22 * this.camZ[o2]);
        float px = m02;
        float py = m12;
        float pz = m22;
        float TEX_WIDTH = this.twidth;
        float TEX_HEIGHT = this.theight;
        float resultT0x = m00 * TEX_WIDTH + m02;
        float resultT0y = m10 * TEX_WIDTH + m12;
        float resultT0z = m20 * TEX_WIDTH + m22;
        float result0Tx = m01 * TEX_HEIGHT + m02;
        float result0Ty = m11 * TEX_HEIGHT + m12;
        float result0Tz = m21 * TEX_HEIGHT + m22;
        float mx = resultT0x - m02;
        float my = resultT0y - m12;
        float mz = resultT0z - m22;
        float nx = result0Tx - m02;
        float ny = result0Ty - m12;
        float nz = result0Tz - m22;
        this.ax = (py * nz - pz * ny) * TEX_WIDTH;
        this.ay = (pz * nx - px * nz) * TEX_WIDTH;
        this.az = (px * ny - py * nx) * TEX_WIDTH;
        this.bx = (my * pz - mz * py) * TEX_HEIGHT;
        this.by = (mz * px - mx * pz) * TEX_HEIGHT;
        this.bz = (mx * py - my * px) * TEX_HEIGHT;
        this.cx = ny * mz - nz * my;
        this.cy = nz * mx - nx * mz;
        this.cz = nx * my - ny * mx;
        this.nearPlaneWidth = this.parent.rightScreen - this.parent.leftScreen;
        this.nearPlaneHeight = this.parent.topScreen - this.parent.bottomScreen;
        this.nearPlaneDepth = this.parent.nearPlane;
        this.xmult = this.nearPlaneWidth / (float)this.parent.width;
        this.ymult = this.nearPlaneHeight / (float)this.parent.height;
        return true;
    }

    private int getTextureIndex(float sx, float sy, float[] uv) {
        sx = this.xmult * (sx - (float)this.parent.width / 2.0f + 0.5f);
        sy = this.ymult * (sy - (float)this.parent.height / 2.0f + 0.5f);
        float sz = this.nearPlaneDepth;
        float a = sx * this.ax + sy * this.ay + sz * this.az;
        float b = sx * this.bx + sy * this.by + sz * this.bz;
        float c = sx * this.cx + sy * this.cy + sz * this.cz;
        int u = (int)(a / c);
        int v = (int)(b / c);
        uv[0] = a / c;
        uv[1] = b / c;
        if (uv[0] < 0.0f) {
            u = 0;
            uv[0] = 0;
        }
        if (uv[1] < 0.0f) {
            v = 0;
            uv[1] = 0;
        }
        if (uv[0] >= (float)this.twidth) {
            uv[0] = this.twidth - 1;
            u = this.twidth - 1;
        }
        if (uv[1] >= (float)this.theight) {
            uv[1] = this.theight - 1;
            v = this.theight - 1;
        }
        int result = v * this.twidth + u;
        return result;
    }

    public void setIntensities(float ar, float ag, float ab, float aa, float br, float bg, float bb, float ba, float cr, float cg, float cb, float ca) {
        this.vertices[0][3] = ar;
        this.vertices[0][4] = ag;
        this.vertices[0][5] = ab;
        this.vertices[0][6] = aa;
        this.vertices[1][3] = br;
        this.vertices[1][4] = bg;
        this.vertices[1][5] = bb;
        this.vertices[1][6] = ba;
        this.vertices[2][3] = cr;
        this.vertices[2][4] = cg;
        this.vertices[2][5] = cb;
        this.vertices[2][6] = ca;
    }
}

