/*
 * Decompiled with CFR 0.152.
 */
package megamu.shapetween;

import megamu.shapetween.Shaper;

public class BounceShaper
extends Shaper {
    protected int bounces = 3;
    protected float decay = 0.3333f;
    protected float totalWidth;
    protected float[] inflections;
    protected float[] heights;
    protected float[] maxima;

    public BounceShaper(int shapeMode, float transitionX, float transitionY) {
        this();
        this.setMode(shapeMode);
        this.setTransitionPoint(transitionX, transitionY);
    }

    public BounceShaper(int shapeMode, float transition) {
        this(shapeMode, transition, transition);
    }

    public BounceShaper(int shapeMode) {
        this();
        this.setMode(shapeMode);
    }

    public BounceShaper() {
        this.calcInflections();
        this.setMode(1);
    }

    public void setBounces(int howMany) {
        this.bounces = howMany;
        this.calcInflections();
    }

    public int getBounces() {
        return this.bounces;
    }

    public void setDecay(float howMuch) {
        this.decay = Math.max(0.0f, Math.min(howMuch, 1.0f));
        this.calcInflections();
    }

    public float getDecay() {
        return this.decay;
    }

    protected void calcInflections() {
        this.inflections = new float[this.bounces + 1];
        this.heights = new float[this.bounces + 1];
        this.maxima = new float[this.bounces + 1];
        this.inflections[0] = -1.0f;
        this.heights[0] = 1.0f;
        this.maxima[0] = 0.0f;
        this.totalWidth = 1.0f;
        float lastHeight = 1.0f;
        int i = 1;
        while (i < this.bounces + 1) {
            this.heights[i] = lastHeight *= this.decay;
            this.inflections[i] = this.totalWidth;
            float width = (float)Math.sqrt(this.heights[i]);
            this.totalWidth += width;
            this.maxima[i] = this.totalWidth;
            this.totalWidth += width;
            ++i;
        }
    }

    protected float f(float x) {
        int bounce = 0;
        x = (1.0f - x) * this.totalWidth;
        while (bounce < this.bounces && x > this.inflections[bounce + 1]) {
            ++bounce;
        }
        float xdiff = x - this.maxima[bounce];
        return this.heights[bounce] - xdiff * xdiff;
    }

    protected float df(float x) {
        int bounce = 0;
        float sx = (1.0f - x) * this.totalWidth;
        while (bounce < this.bounces && sx > this.inflections[bounce + 1]) {
            ++bounce;
        }
        return -2.0f * ((x - 1.0f) * this.totalWidth + this.maxima[bounce]) * this.totalWidth;
    }

    protected float ddf(float x) {
        return 4.0f * this.totalWidth * this.totalWidth;
    }
}

