/*
 * Decompiled with CFR 0.152.
 */
package megamu.shapetween;

import megamu.shapetween.Shaper;

public class BlendShaper
extends Shaper {
    Shaper a;
    Shaper b;
    public float blend;

    public BlendShaper(Shaper a) {
        this(a, null, 0.5f);
    }

    public BlendShaper(Shaper a, Shaper b) {
        this(a, b, 0.5f);
    }

    public BlendShaper(Shaper a, float blend) {
        this(a, null, blend);
    }

    public BlendShaper(Shaper a, Shaper b, float blend) {
        this.a = a;
        this.b = b;
        this.blend = blend;
        this.setMode(0);
    }

    public float getBlend() {
        return this.blend;
    }

    public void setBlend(float blend) {
        this.blend = blend;
    }

    public Shaper getShaperOne() {
        return this.a;
    }

    public Shaper getShaperTwo() {
        return this.b;
    }

    public void setShaperOne(Shaper s) {
        this.a = s;
    }

    public void setShaperTwo(Shaper s) {
        this.b = s;
    }

    protected float f(float x) {
        if (this.blend == 0.0f) {
            return this.a.shape(x);
        }
        if (this.blend == 1.0f) {
            return this.b == null ? x : this.b.shape(x);
        }
        return this.a.shape(x) * (1.0f - this.blend) + (this.b == null ? x : this.b.shape(x)) * this.blend;
    }

    protected float df(float x) {
        if (this.blend == 0.0f) {
            return this.a.slope(x);
        }
        if (this.blend == 1.0f) {
            return this.b == null ? x : this.b.slope(x);
        }
        return this.a.slope(x) * (1.0f - this.blend) + (this.b == null ? x : this.b.slope(x)) * this.blend;
    }

    protected float ddf(float x) {
        if (this.blend == 0.0f) {
            return this.a.secondSlope(x);
        }
        if (this.blend == 1.0f) {
            return this.b == null ? x : this.b.secondSlope(x);
        }
        return this.a.secondSlope(x) * (1.0f - this.blend) + (this.b == null ? x : this.b.secondSlope(x)) * this.blend;
    }
}

