/*
 * Decompiled with CFR 0.152.
 */
package megamu.shapetween;

import java.lang.reflect.Method;
import megamu.shapetween.ShapeTweenConstants;
import megamu.shapetween.Shaper;
import processing.core.PApplet;

public class Tween
implements ShapeTweenConstants {
    public static float timeScale = 1.0f;
    protected double time;
    protected PApplet parent;
    protected float position;
    protected boolean isFrameBased;
    protected double duration;
    protected double lastTime;
    protected boolean isTweening;
    protected boolean inReverse;
    protected int mode;
    protected Method shapeMethod;
    protected boolean useShapeMethod;
    protected Shaper shaper;
    protected int playCount;

    public Tween(PApplet parent, float duration, boolean durationType, Object easing, int mode) {
        this.setDuration(duration, durationType);
        this.mode = mode;
        if (easing != null) {
            this.setEasing(easing);
        }
        if (parent != null) {
            this.parent = parent;
            parent.registerPre((Object)this);
        }
        this.start();
    }

    public Tween(PApplet parent, float duration, boolean durationType, Object easing) {
        this(parent, duration, durationType, easing, 0);
    }

    public Tween(PApplet parent, float duration, boolean durationType) {
        this(parent, duration, durationType, null);
    }

    public Tween(PApplet parent, float duration) {
        this(parent, duration, false);
    }

    public float time() {
        return (float)this.time;
    }

    public float position() {
        return this.position;
    }

    public boolean isTweening() {
        return this.isTweening;
    }

    public void start() {
        this.playCount = 0;
        this.time = this.inReverse ? 1 : 0;
        this.resume();
    }

    public void end() {
        this.pause();
        this.time = !this.inReverse ? 1 : 0;
    }

    public void pause() {
        this.isTweening = false;
    }

    public void resume() {
        this.isTweening = true;
        if (!this.isFrameBased) {
            this.lastTime = System.currentTimeMillis();
        }
        this.updatePosition();
    }

    public void reverse() {
        this.inReverse = !this.inReverse;
    }

    public void seek(float where) {
        this.time = where;
        this.updatePosition();
    }

    public void setDuration(float duration, boolean durationType) {
        this.isFrameBased = durationType;
        this.setDuration(duration);
    }

    public void setDuration(float duration) {
        this.duration = 1.0f / duration;
        if (!this.isFrameBased) {
            this.duration /= 1000.0;
        }
    }

    public void setEasing(Object shape, int easeMode) {
        this.setEasing(shape);
        this.setEasingMode(easeMode);
    }

    public void setEasing(Object shape) {
        try {
            if (shape instanceof String) {
                this.useShapeMethod = true;
                this.shapeMethod = this.parent.getClass().getMethod((String)shape, ShapeTweenConstants.ARGS);
            } else {
                this.useShapeMethod = false;
                this.shaper = shape instanceof Shaper ? (Shaper)shape : (shape instanceof Class ? (Shaper)((Class)shape).newInstance() : null);
            }
            if (this.isTweening) {
                this.updatePosition();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEasingMode(int easeMode) {
        if (this.shaper != null) {
            this.shaper.setMode(easeMode);
        }
    }

    public void noEasing() {
        this.setEasing(null);
    }

    public void setPlayMode(int mode) {
        this.mode = mode;
        this.updatePosition();
    }

    public void repeat() {
        this.mode = this.mode == 2 || this.mode == 3 ? 3 : 1;
    }

    public void noRepeat() {
        this.mode = this.mode == 2 || this.mode == 3 ? 2 : 0;
    }

    public Shaper getEasing() {
        return this.shaper;
    }

    public int playCount() {
        return this.playCount;
    }

    public float speed() {
        if (this.shaper == null) {
            return this.inReverse ? -1 : 1;
        }
        return (float)(this.inReverse ? -1 : 1) * this.shaper.slope((float)this.time);
    }

    public float force() {
        if (this.shaper == null) {
            return 0.0f;
        }
        return (float)(this.inReverse ? -1 : 1) * this.shaper.secondSlope((float)this.time);
    }

    public void tick() {
        if (!this.isTweening) {
            return;
        }
        this.time = this.inReverse ? (this.isFrameBased ? (this.time -= this.duration * (double)timeScale) : (this.time -= ((double)System.currentTimeMillis() - this.lastTime) * this.duration * (double)timeScale)) : (this.isFrameBased ? (this.time += this.duration * (double)timeScale) : (this.time += ((double)System.currentTimeMillis() - this.lastTime) * this.duration * (double)timeScale));
        if (!this.isFrameBased) {
            this.lastTime = System.currentTimeMillis();
        }
        if (this.time >= 1.0 || this.time <= 0.0) {
            ++this.playCount;
            switch (this.mode) {
                case 3: {
                    this.time = (double)(this.time >= 1.0 ? 2 : 0) - this.time;
                    this.reverse();
                    this.resume();
                    break;
                }
                case 1: {
                    this.time += (double)(this.time > 1.0 ? -1 : 1);
                    this.resume();
                    break;
                }
                case 2: {
                    if (this.playCount == 1) {
                        this.time = (double)(this.time >= 1.0 ? 2 : 0) - this.time;
                        this.resume();
                    } else {
                        this.end();
                    }
                    this.reverse();
                    break;
                }
                default: {
                    this.end();
                }
            }
        }
        this.updatePosition();
    }

    public void pre() {
        this.tick();
    }

    private void updatePosition() {
        if (this.useShapeMethod) {
            try {
                Object[] args = new Object[]{new Float(this.time)};
                this.position = ((Float)this.shapeMethod.invoke((Object)this.parent, args)).floatValue();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.shaper == null) {
            this.position = (float)this.time;
            return;
        }
        this.position = this.shaper.shape((float)this.time);
    }
}

