/*
 * Decompiled with CFR 0.152.
 */
package blobDetection;

import blobDetection.Blob;
import blobDetection.BlobDetectionTable;
import blobDetection.BlobTriangle;
import blobDetection.EdgeDetection;
import blobDetection.MetaballsTable;
import java.lang.reflect.Method;

public class BlobDetection
extends EdgeDetection {
    Object parent;
    Method filterBlobMethod;
    public static int blobMaxNumber = 1000;
    public int blobNumber;
    public Blob[] blob;
    public boolean[] gridVisited;
    public int blobWidthMin;
    public int blobHeightMin;
    public boolean isComputeTriangles;
    static /* synthetic */ Class class$0;

    public BlobDetection(int imgWidth, int imgHeight) {
        super(imgWidth, imgHeight);
        this.gridVisited = new boolean[this.nbGridValue];
        this.blob = new Blob[blobMaxNumber];
        this.blobNumber = 0;
        int i = 0;
        while (i < blobMaxNumber) {
            this.blob[i] = new Blob(this);
            ++i;
        }
        this.filterBlobMethod = null;
        this.isComputeTriangles = false;
    }

    public static void setConstants(int blobMaxNb, int blobLinesMaxNb, int blobTrianglesMaxNb) {
        blobMaxNumber = blobMaxNb;
        Blob.MAX_NBLINE = blobLinesMaxNb;
        Blob.MAX_NBTRIANGLE = blobTrianglesMaxNb;
    }

    public void computeTriangles() {
        this.isComputeTriangles = true;
        if (this.isComputeTriangles) {
            int i = 0;
            while (i < blobMaxNumber) {
                this.blob[i].allocateTriangles();
                ++i;
            }
        }
    }

    public void setBlobMaxNumber(int nb) {
        blobMaxNumber = nb;
    }

    public Blob getBlob(int n) {
        Blob b = null;
        if (n < this.blobNumber) {
            return this.blob[n];
        }
        return b;
    }

    public int getBlobNb() {
        return this.blobNumber;
    }

    public void computeBlobs(int[] pixels) {
        int squareIndex;
        int y;
        this.setImage(pixels);
        int i = 0;
        while (i < this.nbGridValue) {
            this.gridVisited[i] = false;
            ++i;
        }
        this.computeIsovalue();
        this.nbLineToDraw = 0;
        float vx = 0.0f;
        this.blobNumber = 0;
        int x = 0;
        while (x < this.resx - 1) {
            float vy = 0.0f;
            y = 0;
            while (y < this.resy - 1) {
                int offset = x + this.resx * y;
                if (!this.gridVisited[offset]) {
                    squareIndex = this.getSquareIndex(x, y);
                    if (squareIndex > 0 && squareIndex < 15 && this.blobNumber < blobMaxNumber) {
                        this.findBlob(this.blobNumber, x, y);
                        ++this.blobNumber;
                    }
                    vy += this.stepy;
                }
                ++y;
            }
            vx += this.stepx;
            ++x;
        }
        this.nbLineToDraw /= 2;
        if (this.isComputeTriangles) {
            boolean tooManyTr = false;
            int i2 = 0;
            while (i2 < this.getBlobNb()) {
                Blob blob = this.getBlob(i2);
                blob.nbTriangle = 0;
                tooManyTr = false;
                y = blob.yGridMin;
                while (y < blob.yGridMax + 1) {
                    x = blob.xGridMin;
                    while (x < blob.xGridMax + 1) {
                        squareIndex = this.getSquareIndex(x, y);
                        int n = 0;
                        while (BlobDetectionTable.edgeVrtTriangles[squareIndex][n] != -1 && !tooManyTr) {
                            BlobTriangle blobTr = blob.triangle[blob.nbTriangle];
                            int[] trOffsetInfoA = BlobDetectionTable.edgeTrOffsetInfo[BlobDetectionTable.edgeVrtTriangles[squareIndex][n]];
                            int[] trOffsetInfoB = BlobDetectionTable.edgeTrOffsetInfo[BlobDetectionTable.edgeVrtTriangles[squareIndex][n + 1]];
                            int[] trOffsetInfoC = BlobDetectionTable.edgeTrOffsetInfo[BlobDetectionTable.edgeVrtTriangles[squareIndex][n + 2]];
                            int offx = trOffsetInfoA[0];
                            int offy = trOffsetInfoA[1];
                            int offAB = trOffsetInfoA[2];
                            blobTr.iA = this.voxel[x + offx + this.resx * (y + offy)] + offAB;
                            offx = trOffsetInfoB[0];
                            offy = trOffsetInfoB[1];
                            offAB = trOffsetInfoB[2];
                            blobTr.iB = this.voxel[x + offx + this.resx * (y + offy)] + offAB;
                            offx = trOffsetInfoC[0];
                            offy = trOffsetInfoC[1];
                            offAB = trOffsetInfoC[2];
                            blobTr.iC = this.voxel[x + offx + this.resx * (y + offy)] + offAB;
                            ++blob.nbTriangle;
                            n += 3;
                            if (blob.nbTriangle < Blob.MAX_NBTRIANGLE) continue;
                            tooManyTr = true;
                            break;
                        }
                        ++x;
                    }
                    ++y;
                }
                ++i2;
            }
        }
    }

    public void findBlob(int iBlob, int x, int y) {
        Blob b = this.blob[iBlob];
        b.id = iBlob;
        b.xMin = 1000.0f;
        b.xMax = -1000.0f;
        b.yMin = 1000.0f;
        b.yMax = -1000.0f;
        b.nbLine = 0;
        b.isFirstTrVisit = true;
        this.computeEdgeVertex(iBlob, x, y);
        if (b.xMin >= 1000.0f || b.xMax <= -1000.0f || b.yMin >= 1000.0f || b.yMax <= -1000.0f) {
            --this.blobNumber;
        } else {
            b.update();
            if (this.filterBlobMethod != null) {
                try {
                    Boolean returnObj = (Boolean)this.filterBlobMethod.invoke(this.parent, b);
                    boolean returnValue = returnObj;
                    if (!returnValue) {
                        --this.blobNumber;
                    }
                }
                catch (Exception e) {
                    System.out.println("Disabling filterBlobMethod() because of an error.");
                    this.filterBlobMethod = null;
                }
            }
        }
    }

    void computeEdgeVertex(int iBlob, int x, int y) {
        int iEdge;
        Blob b = this.blob[iBlob];
        if (b.isFirstTrVisit) {
            b.isFirstTrVisit = false;
            b.xGridMin = b.xGridMax = x;
            b.yGridMin = b.yGridMax = y;
        } else {
            if (x < b.xGridMin) {
                b.xGridMin = x;
            } else if (x > b.xGridMax) {
                b.xGridMax = x;
            }
            if (y < b.yGridMin) {
                b.yGridMin = y;
            } else if (y > b.yGridMax) {
                b.yGridMax = y;
            }
        }
        int offset = x + this.resx * y;
        if (this.gridVisited[offset]) {
            return;
        }
        this.gridVisited[offset] = true;
        int squareIndex = this.getSquareIndex(x, y);
        float vx = (float)x * this.stepx;
        float vy = (float)y * this.stepy;
        int n = 0;
        while ((iEdge = MetaballsTable.edgeCut[squareIndex][n++]) != -1) {
            int[] edgeOffsetInfo = MetaballsTable.edgeOffsetInfo[iEdge];
            int offx = edgeOffsetInfo[0];
            int offy = edgeOffsetInfo[1];
            int offAB = edgeOffsetInfo[2];
            if (this.blob[iBlob].nbLine < Blob.MAX_NBLINE) {
                int n2 = this.voxel[x + offx + this.resx * (y + offy)] + offAB;
                this.blob[iBlob].line[this.blob[iBlob].nbLine++] = n2;
                this.lineToDraw[this.nbLineToDraw++] = n2;
                continue;
            }
            return;
        }
        int toCompute = MetaballsTable.edgeToCompute[squareIndex];
        float t = 0.0f;
        float value = 0.0f;
        if (toCompute > 0) {
            if ((toCompute & 1) > 0) {
                t = (this.isovalue - this.gridValue[offset]) / (this.gridValue[offset + 1] - this.gridValue[offset]);
                this.edgeVrt[this.voxel[offset]].x = value = vx * (1.0f - t) + t * (vx + this.stepx);
                if (value < this.blob[iBlob].xMin) {
                    this.blob[iBlob].xMin = value;
                }
                if (value > this.blob[iBlob].xMax) {
                    this.blob[iBlob].xMax = value;
                }
            }
            if ((toCompute & 2) > 0) {
                t = (this.isovalue - this.gridValue[offset]) / (this.gridValue[offset + this.resx] - this.gridValue[offset]);
                this.edgeVrt[this.voxel[offset] + 1].y = value = vy * (1.0f - t) + t * (vy + this.stepy);
                if (value < this.blob[iBlob].yMin) {
                    this.blob[iBlob].yMin = value;
                }
                if (value > this.blob[iBlob].yMax) {
                    this.blob[iBlob].yMax = value;
                }
            }
        }
        byte neighborVoxel = MetaballsTable.neightborVoxel[squareIndex];
        if (x < this.resx - 2 && (neighborVoxel & 1) > 0) {
            this.computeEdgeVertex(iBlob, x + 1, y);
        }
        if (x > 0 && (neighborVoxel & 2) > 0) {
            this.computeEdgeVertex(iBlob, x - 1, y);
        }
        if (y < this.resy - 2 && (neighborVoxel & 4) > 0) {
            this.computeEdgeVertex(iBlob, x, y + 1);
        }
        if (y > 0 && (neighborVoxel & 8) > 0) {
            this.computeEdgeVertex(iBlob, x, y - 1);
        }
    }

    public void activeCustomFilter(Object parent) {
        this.parent = parent;
        try {
            Class<?> clazz = parent.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("blobDetection.Blob");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            this.filterBlobMethod = clazz.getMethod("newBlobDetectedEvent", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

